/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.gamification.domain;

import java.util.List;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.service.configuration.BadgeService;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationDomainListener
extends Listener<DomainEntity, String> {
    private static final Log LOG = ExoLogger.getLogger(GamificationDomainListener.class);
    protected RuleService ruleService;
    protected BadgeService badgeService;

    public GamificationDomainListener(RuleService ruleService, BadgeService badgeService) {
        this.ruleService = ruleService;
        this.badgeService = badgeService;
    }

    public void onEvent(Event<DomainEntity, String> event) throws Exception {
        LOG.info((Object)"Update Rules related to the edited domain");
        DomainEntity domain = (DomainEntity)event.getSource();
        String action = (String)event.getData();
        List<RuleDTO> rules = this.ruleService.getAllRulesByDomain(domain.getTitle());
        List<BadgeDTO> badges = this.badgeService.findBadgesByDomain(domain.getTitle());
        if (action.equals("delete")) {
            for (RuleDTO rule : rules) {
                rule.setDomainDTO(null);
                rule.setArea("");
                rule.setEnabled(false);
                this.ruleService.updateRule(rule);
            }
            for (BadgeDTO badge : badges) {
                badge.setDomainDTO(null);
                badge.setDomain("");
                badge.setEnabled(false);
                this.badgeService.updateBadge(badge);
            }
        }
        if (action.equals("disable")) {
            for (RuleDTO rule : rules) {
                rule.setEnabled(false);
                this.ruleService.updateRule(rule);
            }
            for (BadgeDTO badge : badges) {
                badge.setEnabled(false);
                this.badgeService.updateBadge(badge);
            }
        }
        if (action.equals("enable")) {
            for (RuleDTO rule : rules) {
                rule.setEnabled(true);
                this.ruleService.updateRule(rule);
            }
            for (BadgeDTO badge : badges) {
                badge.setEnabled(true);
                this.badgeService.updateBadge(badge);
            }
        }
    }
}

