/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.generic;

import java.util.Map;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class GamificationGenericListener
extends Listener<Map<String, String>, String> {
    private static final Log LOG = ExoLogger.getLogger(GamificationGenericListener.class);
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationGenericListener(RuleService ruleService, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void onEvent(Event<Map<String, String>, String> event) throws Exception {
        String ruleTitle = (String)((Map)event.getSource()).get("ruleTitle");
        String senderId = (String)((Map)event.getSource()).get("senderId");
        String receiverId = (String)((Map)event.getSource()).get("receiverId");
        String obj = (String)((Map)event.getSource()).get("object");
        String sender = this.identityManager.getOrCreateIdentity("organization", senderId, false).getId();
        String receiver = this.identityManager.getOrCreateIdentity("organization", receiverId, false).getId();
        this.gamificationService.createHistory(ruleTitle, sender, receiver, obj);
    }
}

