/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="/gamification/gameficationinformationsboard")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class GamificationInformationsEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(GamificationInformationsEndpoint.class);
    protected IdentityManager identityManager = null;
    protected GamificationService gamificationService = null;
    protected SpaceService spaceService;

    public GamificationInformationsEndpoint(IdentityManager identityManager, SpaceService spaceService, GamificationService gamificationService) {
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
        this.spaceService = spaceService;
    }

    @GET
    @Path(value="history/all")
    @RolesAllowed(value={"users"})
    public Response getAllLeadersByRank(@Context UriInfo uriInfo, @QueryParam(value="capacity") String capacity, @QueryParam(value="providerId") String providerId, @QueryParam(value="remoteId") String remoteId) {
        boolean canShowDetails;
        if (StringUtils.isBlank((CharSequence)providerId)) {
            return Response.status((int)400).entity((Object)"identity 'providerId' parameter is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)remoteId)) {
            return Response.status((int)400).entity((Object)"identity 'remoteId' parameter is mandatory").build();
        }
        providerId = IdentityType.getType(providerId).getProviderId();
        boolean isManager = this.isCurrentUserSuperManager();
        boolean bl = canShowDetails = isManager || this.isCurrentUser(providerId, remoteId);
        if ("space".equals(providerId)) {
            boolean isSpaceMember;
            Space space = this.spaceService.getSpaceByPrettyName(remoteId);
            if (space == null) {
                return Response.status((int)404).entity((Object)("Space with pretty name '" + remoteId + "'")).build();
            }
            String currentUsername = this.getCurrentUsername();
            boolean bl2 = isSpaceMember = this.spaceService.isMember(space, currentUsername) || this.spaceService.isSuperManager(currentUsername);
            if (!isSpaceMember) {
                return Response.status((int)403).build();
            }
        }
        ArrayList<GamificationHistoryInfo> historyList = new ArrayList<GamificationHistoryInfo>();
        Identity earnerIdentity = this.identityManager.getOrCreateIdentity(providerId, remoteId);
        try {
            List<GamificationActionsHistory> ss;
            int loadCapacity = 10;
            if (StringUtils.isNotBlank((CharSequence)capacity)) {
                loadCapacity = Integer.parseInt(capacity);
            }
            if ((ss = this.gamificationService.findActionsHistoryByEarnerId(earnerIdentity.getId(), loadCapacity)) == null || ss.isEmpty()) {
                return Response.ok(historyList, (String)"application/json").build();
            }
            for (GamificationActionsHistory element : ss) {
                Identity receiverIdentity = this.identityManager.getIdentity(element.getReceiver(), true);
                Profile profile = receiverIdentity.getProfile();
                GamificationHistoryInfo gamificationHistoryInfo = new GamificationHistoryInfo();
                gamificationHistoryInfo.setSocialId(receiverIdentity.getId());
                gamificationHistoryInfo.setSpace(StringUtils.equals((CharSequence)receiverIdentity.getProviderId(), (CharSequence)"space"));
                gamificationHistoryInfo.setReceiver(element.getReceiver());
                gamificationHistoryInfo.setRemoteId(receiverIdentity.getRemoteId());
                gamificationHistoryInfo.setFullname(profile.getFullName());
                gamificationHistoryInfo.setAvatarUrl(profile.getAvatarUrl());
                gamificationHistoryInfo.setProfileUrl(profile.getUrl());
                gamificationHistoryInfo.setActionScore(element.getActionScore());
                gamificationHistoryInfo.setActionTitle(element.getActionTitle());
                gamificationHistoryInfo.setContext(element.getContext());
                gamificationHistoryInfo.setCreatedDate(element.getCreatedDate().toGMTString());
                gamificationHistoryInfo.setDomain(element.getDomain());
                gamificationHistoryInfo.setGlobalScore(element.getGlobalScore());
                if (canShowDetails) {
                    gamificationHistoryInfo.setObjectId(element.getObjectId());
                }
                historyList.add(gamificationHistoryInfo);
            }
            return Response.ok(historyList, (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error building My points history ", (Throwable)e);
            return Response.serverError().entity((Object)"Error building My points history").build();
        }
    }

    private boolean isCurrentUser(String providerId, String remoteId) {
        return "organization".equals(providerId) && StringUtils.equals((CharSequence)this.getCurrentUsername(), (CharSequence)remoteId);
    }

    private String getCurrentUsername() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    private boolean isCurrentUserSuperManager() {
        return ConversationState.getCurrent().getIdentity().isMemberOf("/platform/administrators");
    }

    public static class GamificationHistoryInfo {
        String socialId;
        boolean isSpace;
        String avatarUrl;
        String remoteId;
        String fullname;
        String profileUrl;
        String createdDate;
        long globalScore;
        String actionTitle;
        String domain;
        String context;
        long actionScore;
        private int loadCapacity = 10;
        private String receiver;
        private String objectId;

        public int getLoadCapacity() {
            return this.loadCapacity;
        }

        public void setLoadCapacity(String loadCapacity) {
            this.loadCapacity = Integer.parseInt(loadCapacity);
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public String getRemoteId() {
            return this.remoteId;
        }

        public void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public String getFullname() {
            return this.fullname;
        }

        public void setFullname(String fullname) {
            this.fullname = fullname;
        }

        public String getProfileUrl() {
            return this.profileUrl;
        }

        public void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }

        public String getSocialId() {
            return this.socialId;
        }

        public void setSocialId(String socialId) {
            this.socialId = socialId;
        }

        public boolean isSpace() {
            return this.isSpace;
        }

        public void setSpace(boolean isSpace) {
            this.isSpace = isSpace;
        }

        public long getGlobalScore() {
            return this.globalScore;
        }

        public void setGlobalScore(long globalScore) {
            this.globalScore = globalScore;
        }

        public String getActionTitle() {
            return this.actionTitle;
        }

        public void setActionTitle(String actionTitle) {
            this.actionTitle = actionTitle;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public long getActionScore() {
            return this.actionScore;
        }

        public void setActionScore(long actionScore) {
            this.actionScore = actionScore;
        }

        public String getCreatedDate() {
            return this.createdDate;
        }

        public void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        public String getReceiver() {
            return this.receiver;
        }

        public void setReceiver(String receiver) {
            this.receiver = receiver;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }
    }
}

