/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.commons.api.persistence.GenericDAO;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class RuleDAO
extends GenericDAOJPAImpl<RuleEntity, Long>
implements GenericDAO<RuleEntity, Long> {
    public RuleEntity findEnableRuleByTitle(String ruleTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findEnabledRuleByTitle", RuleEntity.class).setParameter("ruleTitle", (Object)ruleTitle);
        try {
            return (RuleEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> findEnabledRulesByEvent(String event) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findEnabledRulesByEvent", RuleEntity.class).setParameter("event", (Object)event);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public RuleEntity findRuleByTitle(String ruleTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findRuleByTitle", RuleEntity.class).setParameter("ruleTitle", (Object)ruleTitle);
        try {
            return (RuleEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public RuleEntity findRuleByEventAndDomain(String event, String domain) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findRuleByEventAndDomain", RuleEntity.class).setParameter("event", (Object)event).setParameter("domain", (Object)domain);
        try {
            return (RuleEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getAllRules() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRules", RuleEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getAllRulesByDomain(String domain) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRulesByDomain", RuleEntity.class).setParameter("domain", (Object)domain);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getAllRulesWithNullDomain() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRulesWithNullDomain", RuleEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> getDomainList() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getDomainList", String.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> getAllEvents() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getEventList", String.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

