/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.addons.gamification.service.mapper.EntityMapper;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="/gamification/announcement/api")
@Api(value="/gamification/announcement/api", description="Manages announcement associated to users")
@RolesAllowed(value={"users"})
public class AnnouncementRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(AnnouncementRest.class);
    private AnnouncementService announcementService;

    public AnnouncementRest(AnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="addAnnouncement")
    @ApiOperation(value="Creates a new Announcement", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=403, message="Forbidden operation")})
    public Response createAnnouncement(@ApiParam(value="Announcement object to create", required=true) Announcement announcement) {
        if (announcement == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge object is mandatory").build();
        }
        String currentUser = Utils.getCurrentUser();
        if (StringUtils.isBlank((CharSequence)currentUser)) {
            LOG.warn((Object)"current User is null");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Announcement newAnnouncement = this.announcementService.createAnnouncement(announcement, currentUser, false);
            return Response.ok((Object)EntityMapper.fromAnnouncement(newAnnouncement)).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.warn("Error creating an announcement: { } ", new Object[]{announcement, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="ByChallengeId/{challengeId}")
    @ApiOperation(value="Retrieves the list of challenges available for an owner", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllAnnouncementByChallenge(@Context Request request, @Context UriInfo uriInfo, @ApiParam(value="id of the challenge", required=true) @PathParam(value="challengeId") String challengeId, @ApiParam(value="Offset of result", required=false) @DefaultValue(value="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of result", required=false) @DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        EntityTag eTag = null;
        List<Object> announcementsRestEntities = new ArrayList();
        try {
            List<Announcement> announcements = this.announcementService.findAllAnnouncementByChallenge(Long.parseLong(challengeId), offset, limit);
            announcementsRestEntities = EntityMapper.fromAnnouncementList(announcements);
            eTag = new EntityTag(String.valueOf(announcementsRestEntities.hashCode()));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                builder = EntityBuilder.getResponseBuilder(announcementsRestEntities, (UriInfo)uriInfo, (MediaType)RestUtils.getJsonMediaType(), (Response.Status)Response.Status.OK);
                builder.tag(eTag);
                Date date = new Date(System.currentTimeMillis());
                builder.lastModified(date);
                builder.expires(date);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                builder.cacheControl(cacheControl);
            }
            return builder.build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of announcements", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

