/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.search;

import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.DateFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RuleSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(RuleSearchConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String DATE_FIELD = "@dateField@";
    private static final String START_DATE_QUERY = "@startDateQuery@";
    private static final String END_DATE_QUERY = "@endDateQuery@";
    private static final String DATE_CONDITION = "@condition@";
    private static final String DATE = "@date@";
    private static final String DATE_FILTERING = "@date_filtering@";
    private static final String DOMAIN_FILTERING_QUERY = ",\n        {\n          \"term\": {\n            \"domainId\": {\n              \"value\": \"@domainId@\"\n            }\n          }\n        }\n";
    private static final String AUDIENCE_FILTERING_QUERY = ",\n        {\n          \"terms\": {\n            \"audience\": [\n              @spaceList@\n            ]\n          }\n        }\n";
    private static final String DATE_FILTERING_QUERY = ", \n @startDateQuery@ @endDateQuery@ \n";
    private static final String DATE_FIELD_FILTERING_QUERY = " {\n       \"range\": {\n          \"@dateField@\": {\n            \"@condition@\": \"@date@\"\n           }\n        }\n      }\n";
    private static final String ILLEGAL_SEARCH_CHARACTERS = "\\!?^()+-=<>{}[]:\"*~&|#%@";
    private final ConfigurationManager configurationManager;
    private final ElasticSearchingClient client;
    private String index;
    private String searchQueryFilePath;
    private String searchQuery;
    private IdentityManager identityManager;

    public RuleSearchConnector(ConfigurationManager configurationManager, ElasticSearchingClient client, IdentityManager identityManager, InitParams initParams) {
        this.identityManager = identityManager;
        this.configurationManager = configurationManager;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public List<RuleEntity> search(RuleFilter filter, long offset, long limit) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (StringUtils.isBlank((String)filter.getTerm())) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        String esQuery = this.buildQueryStatement(filter, offset, limit);
        if (StringUtils.isBlank((String)esQuery)) {
            return Collections.emptyList();
        }
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildSearchResult(jsonResponse);
    }

    public int count(RuleFilter filter) {
        if (StringUtils.isBlank((String)filter.getTerm())) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        String esQuery = this.buildQueryStatement(filter, 0L, 0L);
        if (StringUtils.isBlank((String)esQuery)) {
            return 0;
        }
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildCountResult(jsonResponse);
    }

    private String buildQueryStatement(RuleFilter filter, long offset, long limit) {
        String term = this.removeSpecialCharacters(filter.getTerm());
        Set spaceList = Optional.ofNullable(filter.getSpaceIds()).map(HashSet::new).orElse(new HashSet());
        if (StringUtils.isBlank((String)(term = RuleSearchConnector.escapeIllegalCharacterInQuery(term)))) {
            return null;
        }
        term = term.trim();
        List termsQuery = Arrays.stream(term.split(" ")).filter(StringUtils::isNotBlank).map(word -> {
            if (((String)(word = ((String)word).trim())).length() > 4) {
                word = (String)word + "~1";
            }
            return word;
        }).collect(Collectors.toList());
        String termQuery = StringUtils.join(termsQuery, (String)" AND ");
        String query = this.retrieveSearchQuery();
        query = filter.getDomainId() > 0L ? query.replace("@domain_filtering@", DOMAIN_FILTERING_QUERY) : query.replace("@domain_filtering@", "");
        query = !CollectionUtils.isEmpty(filter.getSpaceIds()) ? query.replace("@audience_filtering@", AUDIENCE_FILTERING_QUERY) : query.replace("@audience_filtering@", "");
        DateFilterType dateFilterType = filter.getDateFilterType();
        if (dateFilterType != null) {
            String date = String.valueOf(System.currentTimeMillis());
            switch (dateFilterType) {
                case STARTED: {
                    query = query.replace(DATE_FILTERING, DATE_FILTERING_QUERY);
                    query = query.replace(START_DATE_QUERY, DATE_FIELD_FILTERING_QUERY).replace(DATE_FIELD, START_DATE).replace(DATE_CONDITION, "lte").replace(DATE, date);
                    query = query.replace(END_DATE_QUERY, ", {\n       \"range\": {\n          \"@dateField@\": {\n            \"@condition@\": \"@date@\"\n           }\n        }\n      }\n").replace(DATE_FIELD, END_DATE).replace(DATE_CONDITION, "gte").replace(DATE, date);
                    break;
                }
                case NOT_STARTED: {
                    query = query.replace(DATE_FILTERING, DATE_FILTERING_QUERY);
                    query = query.replace(START_DATE_QUERY, DATE_FIELD_FILTERING_QUERY).replace(END_DATE_QUERY, "").replace(DATE_FIELD, START_DATE).replace(DATE_CONDITION, "gt").replace(DATE, date);
                    break;
                }
                case ENDED: {
                    query = query.replace(DATE_FILTERING, DATE_FILTERING_QUERY);
                    query = query.replace(END_DATE_QUERY, DATE_FIELD_FILTERING_QUERY).replace(START_DATE_QUERY, "").replace(DATE_FIELD, END_DATE).replace(DATE_CONDITION, "lt").replace(DATE, date);
                    break;
                }
                default: {
                    query = query.replace(DATE_FILTERING, "");
                    break;
                }
            }
        } else {
            query = query.replace(DATE_FILTERING, "");
        }
        return query.replace("@domainId@", String.valueOf(filter.getDomainId())).replace("@term@", term).replace("@term_query@", termQuery).replace("@spaceList@", StringUtils.join((Collection)spaceList, (String)",")).replace("@offset@", String.valueOf(offset)).replace("@limit@", String.valueOf(limit));
    }

    private List<RuleEntity> buildSearchResult(String jsonResponse) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<RuleEntity> results = new ArrayList<RuleEntity>();
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                RuleEntity rule = new RuleEntity();
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                JSONObject hitSource = (JSONObject)jsonHitObject.get((Object)"_source");
                long id = this.parseLong(hitSource, "id");
                String title = (String)hitSource.get((Object)"title");
                String description = (String)hitSource.get((Object)"description");
                long score = this.parseLong(hitSource, "score");
                String area = (String)hitSource.get((Object)"area");
                Long domainId = this.parseLong(hitSource, "domainId");
                boolean enabled = Boolean.parseBoolean(String.valueOf(hitSource.get((Object)"enabled")));
                String createdBy = (String)hitSource.get((Object)"createdBy");
                Date createdDate = this.parseDate(hitSource, "createdDate");
                Date lastModifiedDate = this.parseDate(hitSource, "lastModifiedDate");
                String lastModifiedBy = (String)hitSource.get((Object)"lastModifiedBy");
                String event = (String)hitSource.get((Object)"event");
                long audience = this.parseLong(hitSource, "audience");
                Date startDate = this.parseDate(hitSource, START_DATE);
                Date endDate = this.parseDate(hitSource, END_DATE);
                String type = (String)hitSource.get((Object)"type");
                rule.setId(id);
                rule.setTitle(title);
                rule.setDescription(description);
                rule.setEvent(event);
                rule.setDomainEntity(Utils.getDomainById(domainId));
                rule.setScore((int)score);
                rule.setArea(area);
                rule.setEnabled(enabled);
                rule.setAudience(audience);
                rule.setEndDate(endDate);
                rule.setStartDate(startDate);
                rule.setType(EntityType.valueOf(type));
                rule.setManagers(this.getManagersList(hitSource, "managers"));
                rule.setCreatedBy(this.getUserRemoteId(createdBy));
                rule.setCreatedDate(createdDate);
                rule.setLastModifiedBy(this.getUserRemoteId(lastModifiedBy));
                rule.setLastModifiedDate(lastModifiedDate);
                results.add(rule);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing rules search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private int buildCountResult(String jsonResponse) {
        Map json = null;
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return 0;
        }
        JSONObject total = (JSONObject)jsonResult.get((Object)"total");
        return Integer.parseInt(total.get((Object)"value").toString());
    }

    private long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((String)value) ? 0L : Long.parseLong(value);
    }

    private Date parseDate(JSONObject hitSource, String key) {
        Long value = this.parseLong(hitSource, key);
        return value != 0L ? new Date(value) : null;
    }

    private List<Long> getManagersList(JSONObject hitSource, String key) {
        JSONArray jsonHits = (JSONArray)hitSource.get((Object)key);
        if (jsonHits.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> listManagers = new ArrayList<Long>();
        for (Object value : jsonHits) {
            listManagers.add(Long.parseLong(String.valueOf(value)));
        }
        return listManagers;
    }

    private String getUserRemoteId(String id) {
        if (StringUtils.isBlank((String)id)) {
            return "";
        }
        Identity identity = this.identityManager.getIdentity(id);
        return identity != null ? identity.getRemoteId() : "";
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return string;
    }

    public static String escapeIllegalCharacterInQuery(String query) {
        if (StringUtils.isBlank((String)query)) {
            return null;
        }
        for (char c : ILLEGAL_SEARCH_CHARACTERS.toCharArray()) {
            query = query.replace("" + c, "");
        }
        return query;
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((String)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }
}

