/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.Collections;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.exoplatform.addons.gamification.entities.domain.configuration.BadgeEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class BadgeDAO
extends GenericDAOJPAImpl<BadgeEntity, Long> {
    public BadgeEntity findBadgeByTitle(String badgeTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findBadgeByTitle", BadgeEntity.class).setParameter("badgeTitle", (Object)badgeTitle);
        try {
            return (BadgeEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public BadgeEntity findBadgeByTitleAndDomain(String badgeTitle, String domain) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findBadgeByTitleAndDomain", BadgeEntity.class).setParameter("badgeTitle", (Object)badgeTitle).setParameter("domain", (Object)domain);
        try {
            return (BadgeEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<BadgeEntity> findBadgesByDomain(String domain) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findBadgeByDomain", BadgeEntity.class).setParameter("badgeDomain", (Object)domain);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<BadgeEntity> findEnabledBadgesByDomain(String domain) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.findEnabledBadgeByDomain", BadgeEntity.class).setParameter("badgeDomain", (Object)domain);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<BadgeEntity> getAllBadges() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.getAllBadges", BadgeEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<BadgeEntity> getAllBadgesWithNullDomain() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.getAllBadgesWithNullDomain", BadgeEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<String> getDomainList() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationBadge.getDomainList", String.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }
}

