/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.activity;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GamificationActivityListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
    protected ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);

    public void saveActivity(ActivityLifeCycleEvent event) {
        Space space;
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String activityUrl = this.getActivityUrl(activity);
        if (this.isDocumentShareActivity(activity)) {
            this.createActivityGamificationHistoryEntry(activity.getPosterId(), activity.getPosterId(), "uploaddocumentOnNetworkStream", activityUrl);
        }
        if ((space = this.getSpaceOfActivity(activity)) != null) {
            if (activity.getType() == null || !activity.getType().equals("SPACE_ACTIVITY")) {
                this.createActivityGamificationHistoryEntry(activity.getPosterId(), activity.getPosterId(), "addActivityOnSpaceStream", activityUrl);
                if (space.getManagers() != null && space.getManagers().length > 0) {
                    String[] spaceManagers;
                    for (String spaceManager : spaceManagers = space.getManagers()) {
                        this.createActivityGamificationHistoryEntry(spaceManager, spaceManager, "addActivityOnSpaceStreamTarget", activityUrl);
                    }
                }
                this.createSpaceGamificationHistoryEntry(space.getPrettyName(), activity.getPosterId(), "addActivityOnSpaceStream", activityUrl);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)activity.getPosterId(), (CharSequence)activity.getStreamId())) {
            this.createActivityGamificationHistoryEntry(activity.getPosterId(), activity.getStreamId(), "addActivityOnMyStream", activityUrl);
        } else {
            this.createActivityGamificationHistoryEntry(activity.getPosterId(), activity.getStreamId(), "addActivityTargetUserStream", activityUrl);
            this.createActivityGamificationHistoryEntry(activity.getPosterId(), activity.getPosterId(), "addActivityOnNetworkStream", activityUrl);
        }
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        ExoSocialActivity parent = this.activityManager.getParentActivity(activity);
        if (parent == null || StringUtils.equalsIgnoreCase((CharSequence)activity.getPosterId(), (CharSequence)activity.getStreamId())) {
            return;
        }
        String activityUrl = this.getActivityUrl(activity);
        Space space = this.getSpaceOfActivity(parent);
        boolean isSpaceActivity = space != null;
        this.createActivityGamificationHistoryEntry(activity.getPosterId(), parent.getPosterId(), isSpaceActivity ? "addCommentOnSpaceStream" : "addCommentOnNetworkStream", activityUrl);
        this.createActivityGamificationHistoryEntry(parent.getPosterId(), activity.getPosterId(), isSpaceActivity ? "receiveCommentOnSpaceStream" : "receiveCommentOnNetworkStream", activityUrl);
        if (space != null) {
            this.createSpaceGamificationHistoryEntry(space.getPrettyName(), activity.getPosterId(), "addCommentOnSpaceStream", activityUrl);
        }
    }

    public void updateComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)activity.getPosterId(), (CharSequence)activity.getStreamId())) {
            return;
        }
        String[] likersId = activity.getLikeIdentityIds();
        String liker = this.identityManager.getIdentity(likersId[likersId.length - 1]).getId();
        String activityUrl = this.getActivityUrl(activity);
        Space space = this.getSpaceOfActivity(activity);
        boolean isSpaceActivity = space != null;
        this.createActivityGamificationHistoryEntry(liker, activity.getPosterId(), isSpaceActivity ? "likeActivityOnSpaceStream" : "likeActivityOnNetworkStream", activityUrl);
        this.createActivityGamificationHistoryEntry(activity.getPosterId(), liker, isSpaceActivity ? "likeActivityOnSpaceStreamTarget" : "likeActivityTargetUserStream", activityUrl);
        if (space != null) {
            this.createSpaceGamificationHistoryEntry(space.getPrettyName(), liker, "likeActivityOnSpaceStream", activityUrl);
        }
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)activity.getPosterId(), (CharSequence)activity.getStreamId())) {
            return;
        }
        String[] likersId = activity.getLikeIdentityIds();
        String liker = this.identityManager.getIdentity(likersId[likersId.length - 1]).getId();
        String activityUrl = this.getActivityUrl(activity);
        Space space = this.getSpaceOfActivity(activity);
        boolean isSpaceActivity = space != null;
        this.createActivityGamificationHistoryEntry(activity.getPosterId(), liker, isSpaceActivity ? "likeCommentOnSpaceStreamTarget" : "likeCommentOnNetworkStreamTarget", activityUrl);
        this.createActivityGamificationHistoryEntry(liker, activity.getPosterId(), isSpaceActivity ? "likeCommentOnSpaceStream" : "likeCommentOnNetworkStream", activityUrl);
        if (space != null) {
            this.createSpaceGamificationHistoryEntry(space.getPrettyName(), liker, "likeCommentOnSpaceStreamTarget", activityUrl);
        }
    }

    private Space getSpaceOfActivity(ExoSocialActivity activity) {
        if (activity.getParentId() != null) {
            activity = this.activityManager.getParentActivity(activity);
        }
        return this.isSpaceActivity(activity) ? this.spaceService.getSpaceByPrettyName(activity.getActivityStream().getPrettyId()) : null;
    }

    private boolean isSpaceActivity(ExoSocialActivity activity) {
        return activity.getActivityStream() != null && ActivityStream.Type.SPACE.equals((Object)activity.getActivityStream().getType());
    }

    private boolean isDocumentShareActivity(ExoSocialActivity activity) {
        return activity.getType() != null && (activity.getType().equalsIgnoreCase("files:spaces") || activity.getType().equalsIgnoreCase("DOC_ACTIVITY") || activity.getType().equalsIgnoreCase("contents:spaces"));
    }

    private String getActivityUrl(ExoSocialActivity activity) {
        String activityId = activity.getParentId() == null ? activity.getId() : activity.getParentId();
        String commentId = activity.getParentId() == null ? null : activity.getId();
        String activityUrl = "/" + LinkProvider.getPortalName((String)"") + "/" + LinkProvider.getPortalOwner((String)"") + "/activity?id=" + activityId;
        if (commentId != null) {
            activityUrl = activityUrl + "&commentId=" + commentId;
        }
        return activityUrl;
    }

    private void createActivityGamificationHistoryEntry(String senderId, String receiverId, String ruleTitle, String activityUrl) {
        try {
            HashMap<String, String> gam = new HashMap<String, String>();
            gam.put("ruleTitle", ruleTitle);
            gam.put("object", activityUrl);
            gam.put("senderId", senderId);
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast gamification event", (Throwable)e);
        }
    }

    private void createSpaceGamificationHistoryEntry(String spacePrettyName, String receiverId, String ruleTitle, String activityUrl) {
        try {
            HashMap<String, String> gam = new HashMap<String, String>();
            gam.put("ruleTitle", ruleTitle);
            gam.put("object", activityUrl);
            gam.put("senderId", spacePrettyName);
            gam.put("senderType", "space");
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast gamification event", (Throwable)e);
        }
    }
}

