/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.setting.rule.impl;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.setting.rule.RuleRegistry;
import org.exoplatform.addons.gamification.service.setting.rule.model.RuleConfig;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class RuleRegistryImpl
implements Startable,
RuleRegistry {
    private static final Log LOG = ExoLogger.getLogger(RuleRegistryImpl.class);
    public static final String GAMIFICATION_SETTINGS_RULE_KEY = "GAMIFICATION_SETTINGS_RULE_KEY";
    public static final String GAMIFICATION_SETTINGS_RULE_PROCESSING_DONE = "GAMIFICATION_SETTINGS_RULE_PROCESSING_DONE";
    private final Map<String, RuleConfig> ruleMap;
    protected RuleService ruleService;
    protected DomainService domainService;

    public RuleRegistryImpl(DomainService domainService) {
        this.domainService = domainService;
        this.ruleMap = new HashMap<String, RuleConfig>();
    }

    @Override
    public void addPlugin(RuleConfig rule) {
        this.ruleMap.put(rule.getTitle(), rule);
    }

    @Override
    public boolean remove(RuleConfig rule) {
        this.ruleMap.remove(rule.getTitle());
        return true;
    }

    public void start() {
        this.ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
        try {
            for (RuleConfig rule : this.ruleMap.values()) {
                RuleDTO ruleDTO = this.ruleService.findRuleByTitle("def_" + rule.getTitle());
                if (ruleDTO != null && ruleDTO.getEvent().equals(rule.getEvent()) && ruleDTO.getTitle().equals("def_" + rule.getTitle())) continue;
                this.store(rule, ruleDTO);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when processing Rules ", (Throwable)e);
        }
    }

    public void stop() {
    }

    private void store(RuleConfig ruleConfig, RuleDTO ruleDTO) {
        this.domainService = (DomainService)CommonsUtils.getService(DomainService.class);
        try {
            if (ruleDTO != null) {
                ruleDTO.setTitle("def_" + ruleConfig.getTitle());
                ruleDTO.setDescription(ruleConfig.getDescription());
                ruleDTO.setEvent(ruleConfig.getEvent());
                ((RuleService)CommonsUtils.getService(RuleService.class)).updateRule(ruleDTO);
            } else {
                RuleDTO ruleDto = new RuleDTO();
                ruleDto.setTitle("def_" + ruleConfig.getTitle());
                ruleDto.setScore(ruleConfig.getScore());
                ruleDto.setEnabled(ruleConfig.isEnable());
                ruleDto.setEvent(ruleConfig.getEvent());
                ruleDto.setLastModifiedBy("Gamification");
                ruleDto.setCreatedBy("Gamification");
                ruleDto.setDeleted(false);
                ruleDto.setDescription(ruleConfig.getDescription());
                ((RuleService)CommonsUtils.getService(RuleService.class)).createRule(ruleDto);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when saving Rule ", (Throwable)e);
        }
    }
}

