/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.challenges;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.ChallengeService;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.addons.gamification.service.dto.configuration.AnnouncementActivity;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.mapper.EntityMapper;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AnnouncementActivityGeneratorListener
extends Listener<AnnouncementService, AnnouncementActivity> {
    public static final String ANNOUNCEMENT_DESCRIPTION_TEMPLATE_PARAM = "announcementDescription";
    public static final String ANNOUNCEMENT_ID_TEMPLATE_PARAM = "announcementId";
    private static final Log LOG = ExoLogger.getLogger(AnnouncementActivityGeneratorListener.class);
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ActivityManager activityManager;
    private ChallengeService challengeService;

    public AnnouncementActivityGeneratorListener(SpaceService spaceService, IdentityManager identityManager, ActivityManager activityManager, ChallengeService challengeService) {
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
        this.challengeService = challengeService;
    }

    public void onEvent(Event<AnnouncementService, AnnouncementActivity> event) {
        AnnouncementActivity announcementActivity = (AnnouncementActivity)event.getData();
        try {
            Announcement announcement = EntityMapper.fromAnnouncementActivity(announcementActivity);
            AnnouncementService announcementService = (AnnouncementService)event.getSource();
            Identity creatorIdentity = this.identityManager.getIdentity(String.valueOf(announcement.getCreator()));
            Challenge challenge = this.challengeService.getChallengeById(announcement.getChallengeId(), creatorIdentity.getRemoteId());
            ExoSocialActivity activity = this.createActivity(announcement, announcementActivity.getTemplateParams(), challenge);
            announcement.setActivityId(Long.parseLong(activity.getId()));
            announcementService.updateAnnouncement(announcement);
        }
        catch (Exception e) {
            LOG.warn("Error while creating activity for announcement with id {} made by user {}", new Object[]{announcementActivity.getId(), announcementActivity.getCreator(), e});
        }
    }

    private ExoSocialActivity createActivity(Announcement announcement, Map<String, String> params, Challenge challenge) throws ObjectNotFoundException {
        Space space;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        if ((space = this.spaceService.getSpaceById(String.valueOf(challenge.getAudience()))) == null) {
            throw new ObjectNotFoundException("space doesn't exists");
        }
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        if (spaceIdentity == null) {
            throw new ObjectNotFoundException("space doesn't exists");
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType("challenges-announcement");
        activity.setTitle(announcement.getComment());
        activity.setUserId(String.valueOf(announcement.getCreator()));
        params.put(ANNOUNCEMENT_ID_TEMPLATE_PARAM, String.valueOf(announcement.getId()));
        params.put(ANNOUNCEMENT_DESCRIPTION_TEMPLATE_PARAM, challenge.getTitle());
        Utils.buildActivityParams((ExoSocialActivity)activity, params);
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        return this.activityManager.getActivity(activity.getId());
    }
}

