/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.activity.processor;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;

public class ChallengeAnnouncementActivityProcessor
extends BaseActivityProcessorPlugin {
    public static final String ANNOUNCEMENT_COMMENT_PARAM = "announcementComment";
    public static final String ACTIVITY_TYPE = "challenges-announcement";
    private static final Log LOG = ExoLogger.getLogger(ChallengeAnnouncementActivityProcessor.class);
    private static final String APP_URL = "/contributions/challenges/";
    private AnnouncementService announcementService;
    private IdentityManager identityManager;

    public ChallengeAnnouncementActivityProcessor(AnnouncementService announcementService, IdentityManager identityManager, InitParams params) {
        super(params);
        this.announcementService = announcementService;
        this.identityManager = identityManager;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (!ACTIVITY_TYPE.equals(activity.getType())) {
            return;
        }
        if (activity.isComment() || activity.getType() == null) {
            return;
        }
        String announcementId = (String)activity.getTemplateParams().get("announcementId");
        if (StringUtils.isBlank((CharSequence)announcementId)) {
            LOG.error((Object)"announcement id must not null");
            return;
        }
        Announcement announcement = this.announcementService.getAnnouncementById(Long.parseLong(announcementId));
        if (announcement == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        Identity identity = this.identityManager.getIdentity(String.valueOf(announcement.getAssignee()));
        if (identity != null) {
            String title;
            params.put("announcementAssigneeUsername", identity.getRemoteId());
            params.put("announcementAssigneeFullName", identity.getProfile().getFullName());
            params.put("announcementChallenge", this.getAnnouncementChallenge(String.valueOf(announcement.getChallengeId()), (String)activity.getTemplateParams().get("announcementDescription")));
            if (activity.getTemplateParams().containsKey(ANNOUNCEMENT_COMMENT_PARAM) && StringUtils.isNotBlank((CharSequence)(title = (String)activity.getTemplateParams().get(ANNOUNCEMENT_COMMENT_PARAM)))) {
                activity.setTitle(title);
                activity.getTemplateParams().put(ANNOUNCEMENT_COMMENT_PARAM, null);
            }
            activity.getTemplateParams().putAll(params);
        }
    }

    private String getAnnouncementChallenge(String challengeId, String challengeDescription) {
        StringBuilder challenge = new StringBuilder();
        challenge.append("<a class='primary--text' href=\"");
        String portalName = LinkProvider.getPortalName((String)"");
        String portalOwner = LinkProvider.getPortalOwner((String)"");
        String url = "/" + portalName + "/" + portalOwner + APP_URL + challengeId;
        challenge.append(url);
        challenge.append("\" target=\"_self\"  rel=\"nofollow\"> ");
        challenge.append(challengeDescription);
        challenge.append(" </a>");
        return String.valueOf(challenge);
    }
}

