/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.BadgeEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.mapper.BadgeMapper;
import org.exoplatform.addons.gamification.storage.dao.BadgeDAO;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BadgeService {
    private static final Log LOG = ExoLogger.getLogger(BadgeService.class);
    protected final BadgeDAO badgeStorage = (BadgeDAO)((Object)CommonsUtils.getService(BadgeDAO.class));

    public BadgeDTO findBadgeByTitle(String badgeTitle) {
        try {
            BadgeEntity entity = this.badgeStorage.findBadgeByTitle(badgeTitle);
            if (entity != null) {
                return BadgeMapper.badgeToBadgeDTO(entity);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badge entity with title : {}", new Object[]{badgeTitle, e.getMessage()});
        }
        return null;
    }

    public BadgeDTO findBadgeById(Long badgeId) {
        try {
            BadgeEntity entity = (BadgeEntity)this.badgeStorage.find(badgeId);
            if (entity != null) {
                return BadgeMapper.badgeToBadgeDTO(entity);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badge entity with id : {}", new Object[]{badgeId, e.getMessage()});
        }
        return null;
    }

    public BadgeDTO findBadgeByTitleAndDomain(String badgeTitle, String domain) {
        try {
            BadgeEntity entity = this.badgeStorage.findBadgeByTitleAndDomain(badgeTitle, domain);
            if (entity != null) {
                return BadgeMapper.badgeToBadgeDTO(entity);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badge entity with title : {}", new Object[]{badgeTitle, e.getMessage()});
        }
        return null;
    }

    public List<BadgeDTO> getAllBadges() {
        List<BadgeEntity> badges = this.badgeStorage.getAllBadges();
        if (CollectionUtils.isNotEmpty(badges)) {
            return BadgeMapper.badgesToBadgeDTOs(badges);
        }
        return Collections.emptyList();
    }

    public BadgeDTO addBadge(BadgeDTO badgeDTO) throws ObjectAlreadyExistsException {
        BadgeEntity badgeEntity = null;
        if (badgeDTO.getDomainDTO() != null) {
            badgeDTO.setDomain(badgeDTO.getDomainDTO().getTitle());
        }
        if ((badgeEntity = this.badgeStorage.findBadgeByTitleAndDomain(badgeDTO.getTitle(), badgeDTO.getDomain())) == null) {
            if (badgeDTO.getDomainDTO() == null || !badgeDTO.getDomainDTO().isEnabled()) {
                badgeDTO.setEnabled(false);
            }
            badgeEntity = (BadgeEntity)this.badgeStorage.create(BadgeMapper.badgeDTOToBadge(badgeDTO));
        } else if (badgeEntity.isDeleted()) {
            Long id = badgeEntity.getId();
            badgeEntity = BadgeMapper.badgeDTOToBadge(badgeDTO);
            badgeEntity.setId(id);
            if (badgeDTO.getDomainDTO() == null || !badgeDTO.getDomainDTO().isEnabled()) {
                badgeDTO.setEnabled(false);
            }
            badgeEntity = (BadgeEntity)this.badgeStorage.update(badgeEntity);
        } else {
            throw new ObjectAlreadyExistsException((Object)"Badge already exists");
        }
        return BadgeMapper.badgeToBadgeDTO(badgeEntity);
    }

    public BadgeDTO updateBadge(BadgeDTO badgeDTO) throws ObjectAlreadyExistsException {
        BadgeEntity badgeEntity = null;
        if (badgeDTO.getDomainDTO() != null) {
            badgeDTO.setDomain(badgeDTO.getDomainDTO().getTitle());
        }
        if ((badgeEntity = this.badgeStorage.findBadgeByTitleAndDomain(badgeDTO.getTitle(), badgeDTO.getDomain())) != null && badgeDTO.getId() != null && badgeEntity.getId().longValue() != badgeDTO.getId().longValue()) {
            throw new ObjectAlreadyExistsException((Object)"Badge with same title and domain already exist");
        }
        if (badgeDTO.getDomainDTO() == null || !badgeDTO.getDomainDTO().isEnabled()) {
            badgeDTO.setEnabled(false);
        }
        badgeEntity = (BadgeEntity)this.badgeStorage.update(BadgeMapper.badgeDTOToBadge(badgeDTO));
        return BadgeMapper.badgeToBadgeDTO(badgeEntity);
    }

    public void deleteBadge(Long id) throws ObjectNotFoundException {
        BadgeEntity badgeEntity = (BadgeEntity)this.badgeStorage.find(id);
        if (badgeEntity == null) {
            throw new ObjectNotFoundException("Badge with id " + id + " not Found");
        }
        badgeEntity.setDeleted(true);
        this.badgeStorage.update(badgeEntity);
    }

    public List<BadgeDTO> findBadgesByDomain(String badgeDomain) {
        try {
            List<BadgeEntity> badges = this.badgeStorage.findBadgesByDomain(badgeDomain);
            if (badges != null) {
                return BadgeMapper.badgesToBadgeDTOs(badges);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find badges within domain {}", new Object[]{badgeDomain, e});
        }
        return Collections.emptyList();
    }

    public List<BadgeDTO> findEnabledBadgesByDomain(String badgeDomain) {
        try {
            List<BadgeEntity> badges = this.badgeStorage.findEnabledBadgesByDomain(badgeDomain);
            if (badges != null) {
                return BadgeMapper.badgesToBadgeDTOs(badges);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find badges within domain {}", new Object[]{badgeDomain, e});
        }
        return Collections.emptyList();
    }

    public List<BadgeDTO> getAllBadgesWithNullDomain() {
        try {
            List<BadgeEntity> rules = this.badgeStorage.getAllBadgesWithNullDomain();
            if (rules != null) {
                return BadgeMapper.badgesToBadgeDTOs(rules);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error to find Badges", (Throwable)e);
            throw e;
        }
        return Collections.emptyList();
    }

    public List<String> getDomainListFromBadges() {
        return this.badgeStorage.getDomainList();
    }
}

