/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.rest.EntityBuilder;
import org.exoplatform.addons.gamification.rest.model.DomainList;
import org.exoplatform.addons.gamification.rest.model.DomainRestEntity;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityStatusType;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="/gamification/domains")
@Produces(value={"application/json"})
public class ManageDomainsEndpoint
implements ResourceContainer {
    private static final String DEFAULT_COVER_PATH = System.getProperty("meeds.engagementCenter.program.defaultCoverPath", "/skin/images/program_default_cover_back.png");
    private static final String DOMAIN_NOT_FOUND_MESSAGE = "The domain doesn't exit";
    private static final Log LOG = ExoLogger.getLogger(ManageDomainsEndpoint.class);
    private static final int CACHE_IN_SECONDS = 604800;
    private static final int CACHE_IN_MILLI_SECONDS = 604800000;
    private static final CacheControl CACHECONTROL = new CacheControl();
    protected PortalContainer portalContainer;
    protected DomainService domainService;
    protected IdentityManager identityManager;
    public byte[] defaultProgramCover = null;

    public ManageDomainsEndpoint(PortalContainer portalContainer, DomainService domainService, IdentityManager identityManager) {
        this.portalContainer = portalContainer;
        this.domainService = domainService;
        this.identityManager = identityManager;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of available domains", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getDomains(@Parameter(description="Offset of results to retrieve", required=false) @QueryParam(value="offset") @DefaultValue(value="0") int offset, @Parameter(description="Limit of results to retrieve", required=false) @QueryParam(value="limit") @DefaultValue(value="0") int limit, @Parameter(description="Domains type filtering, possible values: AUTOMATIC, MANUAL and ALL. Default value = AUTOMATIC.", required=false) @QueryParam(value="type") @DefaultValue(value="AUTOMATIC") String type, @Parameter(description="Domains status filtering, possible values: ENABLED, DISABLED and ALL. Default value = ENABLED.", required=false) @QueryParam(value="status") @DefaultValue(value="ENABLED") String status, @Parameter(description="If true, this will return the filtered domains sorted by budget. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="sortByBudget") @DefaultValue(value="false") boolean sortByBudget, @Parameter(description="If true, this will return the filtered domains including deleted domains. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="includeDeleted") @DefaultValue(value="false") boolean includeDeleted, @Parameter(description="If true, this will return the total count of filtered domains. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="returnSize") @DefaultValue(value="false") boolean returnSize, @Parameter(description="Term to search.", required=false) @QueryParam(value="query") String query) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setSortByBudget(sortByBudget);
        domainFilter.setIncludeDeleted(includeDeleted);
        EntityFilterType filterType = StringUtils.isBlank((CharSequence)type) ? EntityFilterType.AUTOMATIC : EntityFilterType.valueOf(type);
        domainFilter.setEntityFilterType(filterType);
        EntityStatusType statusType = StringUtils.isBlank((CharSequence)status) ? EntityStatusType.ENABLED : EntityStatusType.valueOf(status);
        domainFilter.setEntityStatusType(statusType);
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            domainFilter.setDomainTitle(query);
        }
        String currentUser = Utils.getCurrentUser();
        DomainList domainList = new DomainList();
        List<DomainRestEntity> domains = this.getDomainsRestEntitiesByFilter(domainFilter, offset, limit, currentUser);
        if (returnSize) {
            int domainsSize = this.domainService.countDomains(domainFilter, currentUser);
            domainList.setDomainsSize(domainsSize);
        }
        domainList.setDomains(domains);
        domainList.setDomainsOffset(offset);
        domainList.setDomainsLimit(limit);
        return Response.ok((Object)domainList).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a domain", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createDomain(@Parameter(description="Domain object to create", required=true) DomainDTO domainDTO) {
        if (domainDTO == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Domain object is mandatory").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            domainDTO = this.domainService.createDomain(domainDTO, identity);
            return Response.ok((Object)EntityBuilder.toRestEntity(domainDTO, identity.getUserId())).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Unauthorized user {} attempts to create a domain", new Object[]{identity.getUserId()});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"unauthorized user trying to update a domain").build();
        }
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="updates created domain", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateDomain(@Parameter(description="domain id", required=true) @PathParam(value="id") long domainId, @Parameter(description="domain object to update", required=true) DomainDTO domainDTO) {
        if (domainDTO == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"domain object is mandatory").build();
        }
        if (domainId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"domain technical identifier must be positive").build();
        }
        domainDTO.setId(domainId);
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            domainDTO = this.domainService.updateDomain(domainDTO, identity);
            return Response.ok((Object)EntityBuilder.toRestEntity(domainDTO, identity.getUserId())).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Unauthorized user {} attempts to update the domain {}", new Object[]{identity.getUserId(), domainDTO.getId()});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"unauthorized user trying to update a domain").build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)DOMAIN_NOT_FOUND_MESSAGE).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"administrators"})
    @Path(value="{domainId}")
    @Operation(summary="Deletes an existing domain identified by its id", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteDomain(@Parameter(description="domain id to be deleted", required=true) @PathParam(value="domainId") long domainId) {
        if (domainId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The parameter 'id' must be positive integer").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            DomainDTO domainDTO = this.domainService.deleteDomainById(domainId, identity);
            return Response.ok().entity((Object)domainDTO).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)DOMAIN_NOT_FOUND_MESSAGE).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("unauthorized user {} trying to delete domain with id {}", new Object[]{identity.getUserId(), domainId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @GET
    @Path(value="canAddProgram")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="check if the current user can add a program", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User ability to add a program is returned"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response canAddProgram() {
        Identity identity = ConversationState.getCurrent().getIdentity();
        return Response.ok((Object)String.valueOf(this.domainService.canAddDomain(identity))).build();
    }

    @GET
    @Path(value="{id}/cover")
    @Produces(value={"image/png"})
    @Operation(summary="Gets a domain cover", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden request"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getDomainCoverById(@Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") Long lastModified, @Parameter(description="domain id", required=true) @PathParam(value="id") String domainId, @Parameter(description="A mandatory valid token that is used to authorize anonymous request", required=true) @QueryParam(value="r") String token) throws IOException {
        boolean isDefault = StringUtils.equals((CharSequence)"default-cover", (CharSequence)domainId);
        String lastUpdated = null;
        DomainDTO domain = null;
        if (isDefault) {
            lastUpdated = Utils.toRFC3339Date(new Date(Utils.DEFAULT_COVER_LAST_MODIFIED));
        } else {
            domain = this.domainService.getDomainById(Long.valueOf(domainId));
            if (domain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)DOMAIN_NOT_FOUND_MESSAGE).build();
            }
            isDefault = domain.getCoverFileId() == 0L;
            lastUpdated = domain.getLastModifiedDate();
        }
        try {
            if (!isDefault && RestUtils.isAnonymous() && !Utils.isAttachmentTokenValid(token, domainId, "cover", lastModified)) {
                LOG.warn("An anonymous user attempts to access avatar of space {} without a valid access token", new Object[]{domainId});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            EntityTag eTag = new EntityTag(lastUpdated);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = isDefault ? this.getDefaultCoverInputStream() : this.domainService.getFileDetailAsStream(Long.valueOf(domainId));
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
            if (lastModified != null) {
                builder.cacheControl(CACHECONTROL);
                builder.lastModified(Utils.parseRFC3339Date(lastUpdated));
                builder.expires(new Date(System.currentTimeMillis() + 604800000L));
            }
            return builder.build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)DOMAIN_NOT_FOUND_MESSAGE).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{domainId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves a domain by its id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getDomainById(@Parameter(description="domain id", required=true) @PathParam(value="domainId") long domainId) {
        if (domainId == 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"DomainId must be not null").build();
        }
        String currentUser = Utils.getCurrentUser();
        DomainDTO domain = this.domainService.getDomainById(domainId);
        if (domain == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)DOMAIN_NOT_FOUND_MESSAGE).build();
        }
        return Response.ok((Object)EntityBuilder.toRestEntity(domain, currentUser)).build();
    }

    private List<DomainRestEntity> getDomainsRestEntitiesByFilter(DomainFilter filter, int offset, int limit, String currentUser) {
        List<DomainDTO> domains = this.domainService.getDomainsByFilter(filter, currentUser, offset, limit);
        return EntityBuilder.toRestEntities(domains, currentUser);
    }

    public InputStream getDefaultCoverInputStream() throws IOException {
        if (this.defaultProgramCover == null) {
            InputStream is = this.portalContainer.getPortalContext().getResourceAsStream(DEFAULT_COVER_PATH);
            this.defaultProgramCover = is == null ? new byte[0] : IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        return new ByteArrayInputStream(this.defaultProgramCover);
    }

    static {
        CACHECONTROL.setMaxAge(604800);
        CACHECONTROL.setPrivate(false);
    }
}

