/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.es;

import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class RulesESListener
extends Listener<Object, Long> {
    private static final Log LOG = ExoLogger.getLogger(RulesESListener.class);
    private PortalContainer container;
    private IndexingService indexingService;
    private RuleService ruleService;

    public RulesESListener(PortalContainer container, IndexingService indexingService, RuleService ruleService) {
        this.container = container;
        this.indexingService = indexingService;
        this.ruleService = ruleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, Long> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        Long ruleId = (Long)event.getData();
        boolean ruleDeleted = "rule.deleted".equals(event.getEventName());
        RuleDTO rule = ruleDeleted ? null : this.ruleService.findRuleById(ruleId);
        try {
            if (rule == null || rule.isDeleted() || !rule.isEnabled() && EntityType.MANUAL != rule.getType()) {
                LOG.debug("Notifying unindexing service for rule with id={}", new Object[]{ruleId});
                this.indexingService.unindex("rules", String.valueOf(ruleId));
            } else {
                LOG.debug("Notifying indexing service for rule with id={}", new Object[]{ruleId});
                this.indexingService.reindex("rules", String.valueOf(ruleId));
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

