/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.filter.EventFilter;
import io.meeds.gamification.plugin.EventConfigPlugin;
import io.meeds.gamification.service.EventRegistry;
import io.meeds.gamification.service.EventService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class EventRegistryImpl
implements Startable,
EventRegistry {
    private static final Log LOG = ExoLogger.getLogger(EventRegistryImpl.class);
    private final Map<String, EventConfigPlugin> eventConfigPluginMap = new HashMap<String, EventConfigPlugin>();
    private final EventService eventService;

    public EventRegistryImpl(EventService eventService) {
        this.eventService = eventService;
    }

    @Override
    public void addPlugin(EventConfigPlugin eventConfigPlugin) {
        if (StringUtils.isNotBlank((CharSequence)eventConfigPlugin.getName())) {
            this.eventConfigPluginMap.put(eventConfigPlugin.getName(), eventConfigPlugin);
        }
    }

    @Override
    public boolean remove(EventConfigPlugin eventConfigPlugin) {
        this.eventConfigPluginMap.remove(eventConfigPlugin.getName());
        return true;
    }

    public void start() {
        for (EventConfigPlugin eventConfigPlugin : this.eventConfigPluginMap.values()) {
            EventDTO eventConfig = eventConfigPlugin.getEvent();
            EventDTO eventDTO2 = this.eventService.getEventByTypeAndTitle(eventConfig.getType(), eventConfig.getTitle());
            if (eventDTO2 == null) {
                eventDTO2 = new EventDTO();
                eventDTO2.setTitle(eventConfig.getTitle());
                eventDTO2.setType(eventConfig.getType());
                eventDTO2.setTrigger(eventConfig.getTrigger());
                eventDTO2.setCancellerEvents(eventConfig.getCancellerEvents());
                try {
                    this.eventService.createEvent(eventDTO2);
                    continue;
                }
                catch (ObjectAlreadyExistsException e) {
                    throw new IllegalStateException(String.format("Event '%s' seems already exists", eventConfig.getTitle()), e);
                }
            }
            if (Objects.equals(eventDTO2.getCancellerEvents(), eventConfig.getCancellerEvents())) continue;
            eventDTO2.setCancellerEvents(eventConfig.getCancellerEvents());
            try {
                this.eventService.updateEvent(eventDTO2);
            }
            catch (ObjectNotFoundException e) {
                throw new IllegalStateException(String.format("Event '%s' not found", eventConfig.getTitle()), e);
            }
        }
        List<EventDTO> eventDAOList = this.eventService.getEvents(new EventFilter(), 0, -1);
        eventDAOList.forEach(eventDTO -> {
            EventConfigPlugin eventConfigPlugin = this.eventConfigPluginMap.values().stream().filter(eventConfig -> eventConfig.getEvent().getType().equals(eventDTO.getType()) && eventConfig.getEvent().getTitle().equals(eventDTO.getTitle())).findFirst().orElse(null);
            if (eventConfigPlugin == null) {
                try {
                    this.eventService.deleteEventById(eventDTO.getId());
                }
                catch (ObjectNotFoundException e) {
                    LOG.warn("Error while clean gamification event {}", new Object[]{eventDTO.getId(), e});
                }
            }
        });
    }

    public void stop() {
    }
}

