/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.plugin.ConnectorPlugin;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.Collection;
import java.util.HashSet;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConnectorServiceTest
extends AbstractServiceTest {
    private static final String ADMIN_USER = "root1";
    private Identity adminAclIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.adminAclIdentity = this.registerAdministratorUser(ADMIN_USER);
    }

    public void testGetUserRemoteConnectors() throws IllegalAccessException {
        RemoteConnectorSettings remoteConnectorSettings = this.connectorSettingService.getConnectorSettings("connectorName", this.adminAclIdentity);
        remoteConnectorSettings.setName("connectorName");
        remoteConnectorSettings.setApiKey("12345apiKey");
        remoteConnectorSettings.setSecretKey("12345SecretKey");
        remoteConnectorSettings.setRedirectUrl("http://localhost:8080");
        remoteConnectorSettings.setEnabled(true);
        this.connectorSettingService.saveConnectorSettings(remoteConnectorSettings, this.adminAclIdentity);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.connectorService.getConnectors(null));
        this.setConnectorPlugin("connectorName", "connectorIdentifier");
        this.setConnectorPlugin("connectorName1", "connectorIdentifier2");
        Collection remoteConnectorList = this.connectorService.getConnectors(ADMIN_USER);
        ConnectorServiceTest.assertEquals((int)2, (int)remoteConnectorList.size());
        this.removeConnectorPlugin("connectorName1");
        remoteConnectorList = this.connectorService.getConnectors(ADMIN_USER);
        ConnectorServiceTest.assertEquals((int)1, (int)remoteConnectorList.size());
    }

    public void testConnectorConnection() throws ObjectAlreadyExistsException {
        ConnectorPlugin connectorPlugin = (ConnectorPlugin)Mockito.mock(ConnectorPlugin.class);
        Mockito.when((Object)connectorPlugin.getConnectorName()).thenReturn((Object)"connectorName");
        Mockito.when((Object)connectorPlugin.getName()).thenReturn((Object)"connectorName");
        String connectorUserId = "root1RemoteId";
        Mockito.when((Object)connectorPlugin.validateToken(connectorUserId, "testToken")).thenReturn((Object)connectorUserId);
        this.connectorService.addPlugin(connectorPlugin);
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/users", "member"));
        Identity root1 = new Identity(ADMIN_USER, memberships);
        this.identityRegistry.register(root1);
        String result = this.connectorService.connect("connectorName", connectorUserId, "testToken", root1);
        ConnectorServiceTest.assertEquals((String)connectorUserId, (String)result);
        ((ConnectorPlugin)Mockito.verify((Object)connectorPlugin, (VerificationMode)Mockito.times((int)1))).validateToken(connectorUserId, "testToken");
    }

    private void removeConnectorPlugin(String connectorName) {
        this.connectorService.removePlugin(connectorName);
    }

    private void setConnectorPlugin(final String connectorName, String connectorIdentifier) {
        this.removeConnectorPlugin(connectorName);
        ConnectorPlugin connectorPlugin = new ConnectorPlugin(){

            public String validateToken(String accessToken) {
                return null;
            }

            public String getConnectorName() {
                return connectorName;
            }
        };
        connectorPlugin.setName(connectorName);
        this.connectorService.addPlugin(connectorPlugin);
    }
}

