/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import java.util.HashMap;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class GamificationRuleListener
extends Listener<Object, String> {
    private static final Log LOG = ExoLogger.getLogger(GamificationRuleListener.class);
    private final ListenerService listenerService;
    private final RuleService ruleService;
    private final IdentityManager identityManager;

    public GamificationRuleListener(ListenerService listenerService, RuleService ruleService, IdentityManager identityManager) {
        this.listenerService = listenerService;
        this.ruleService = ruleService;
        this.identityManager = identityManager;
    }

    public void onEvent(Event<Object, String> event) {
        Object object = event.getSource();
        boolean ruleDeleted = "rule.deleted".equals(event.getEventName());
        RuleDTO rule = ruleDeleted ? (RuleDTO)object : this.ruleService.findRuleById((Long)object);
        String createdBy = rule.getCreatedBy();
        String userIdentityId = this.identityManager.getOrCreateUserIdentity(createdBy).getId();
        this.createRuleGamificationHistoryEntry(userIdentityId, userIdentityId, String.valueOf(rule.getId()), ruleDeleted ? "gamification.delete.event.action" : "exo.gamification.generic.action");
    }

    private void createRuleGamificationHistoryEntry(String earnerIdentityId, String receiverId, String ruleId, String gamificationEventName) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", "createRule");
            gam.put("objectId", ruleId);
            gam.put("objectType", "activity");
            gam.put("senderId", earnerIdentityId);
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast(gamificationEventName, gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }
}

