/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.EntityVisibility;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.UserInfoContext;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.rest.ProgramRest;
import io.meeds.gamification.rest.model.ProgramList;
import io.meeds.gamification.rest.model.ProgramRestEntity;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class TestProgramRest
extends AbstractServiceTest {
    private ProgramDTO autoDomain;
    private ProgramDTO manualDomain;

    protected Class<?> getComponentClass() {
        return ProgramRest.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.autoDomain = this.newProgram(EntityType.AUTOMATIC, "domain1", true, Collections.singleton(1L));
        this.manualDomain = this.newProgram(EntityType.MANUAL, "domain2", true, Collections.singleton(1L));
        ConversationState.setCurrent(null);
        this.registry(this.getComponentClass());
    }

    @Test
    public void testGetPrograms() throws Exception {
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs?offset=0&limit=10"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs?offset=0&limit=10&type=MANUAL&returnSize=true"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetProgramWithDeletedSpace() throws Exception {
        ProgramEntity programEntity = (ProgramEntity)this.programDAO.find((Serializable)Long.valueOf(this.autoDomain.getId()));
        programEntity.setAudienceId(Long.valueOf(25564L));
        this.programDAO.update((Object)programEntity);
        this.startSessionAsAdministrator("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs/" + this.autoDomain.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramRestEntity program = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertNotNull((Object)program);
        TestProgramRest.assertNull((Object)program.getSpace());
        TestProgramRest.assertEquals((long)programEntity.getAudienceId(), (long)program.getSpaceId());
    }

    @Test
    public void testGetProgramAdministrators() throws Exception {
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramList programList = (ProgramList)response.getEntity();
        TestProgramRest.assertNotNull((Object)programList);
        TestProgramRest.assertNull((Object)programList.getAdministrators());
        response = this.getResponse("GET", this.getURLResource("programs?expand=administrators"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        programList = (ProgramList)response.getEntity();
        TestProgramRest.assertNotNull((Object)programList);
        TestProgramRest.assertNotNull((Object)programList.getAdministrators());
    }

    @Test
    public void testCreateProgram() throws Exception {
        ProgramDTO domain = this.manualDomain.clone();
        domain.setId(0L);
        domain.setTitle("foo");
        domain.setDescription("fooDescription");
        JSONObject domainData = new JSONObject();
        domainData.put("id", domain.getId());
        domainData.put("title", (Object)domain.getTitle());
        domainData.put("description", (Object)domain.getDescription());
        ContainerResponse response = this.getResponse("POST", this.getURLResource("programs"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)400, (int)response.getStatus());
        this.startSessionAs("user");
        response = this.getResponse("POST", this.getURLResource("programs"), domainData.toString());
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("POST", this.getURLResource("programs"), domainData.toString());
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAsAdministrator("root1");
        response = this.getResponse("POST", this.getURLResource("programs"), domainData.toString());
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramRestEntity program = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertEquals((String)"foo", (String)program.getTitle());
        TestProgramRest.assertEquals((String)"fooDescription", (String)program.getDescription());
    }

    @Test
    public void testUpdateProgram() throws Exception {
        ProgramDTO domain = this.autoDomain.clone();
        domain.setId(0L);
        JSONObject domainData = new JSONObject();
        domainData.put("id", domain.getId());
        ContainerResponse response = this.getResponse("PUT", this.getURLResource("programs/" + domain.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("PUT", this.getURLResource("programs/" + domain.getId()), domainData.toString());
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)400, (int)response.getStatus());
        domain = this.autoDomain.clone();
        this.startSessionAs("root10");
        response = this.getResponse("PUT", this.getURLResource("programs/" + domain.getId()), domainData.toString());
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)401, (int)response.getStatus());
        domain.setTitle("TeamWork modified");
        domain.setDescription("description modified");
        domainData = new JSONObject();
        domainData.put("id", domain.getId());
        domainData.put("title", (Object)domain.getTitle());
        domainData.put("description", (Object)domain.getDescription());
        this.startSessionAsAdministrator("root1");
        response = this.getResponse("PUT", this.getURLResource("programs/" + domain.getId()), domainData.toString());
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramRestEntity program = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertEquals((String)"TeamWork modified", (String)program.getTitle());
        TestProgramRest.assertEquals((String)"description modified", (String)program.getDescription());
    }

    @Test
    public void testDeleteDomain() throws Exception {
        ContainerResponse response = this.getResponse("DELETE", this.getURLResource("programs/0"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)400, (int)response.getStatus());
        this.startSessionAs("root10");
        response = this.getResponse("DELETE", this.getURLResource("programs/" + this.manualDomain.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("DELETE", this.getURLResource("programs/" + this.autoDomain.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)204, (int)response.getStatus());
    }

    @Test
    public void testGetProgramCoverById() throws Exception {
        long lastUpdateCoverTime = Utils.parseRFC3339Date((String)this.manualDomain.getLastModifiedDate()).getTime();
        String token = URLEncoder.encode(Utils.generateAttachmentToken((String)String.valueOf(this.manualDomain.getId()), (String)"cover", (Long)lastUpdateCoverTime), StandardCharsets.UTF_8);
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs/default-cover/cover?lastModified=" + lastUpdateCoverTime + "&r=" + token), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs/155/cover?lastModified=" + lastUpdateCoverTime + "&r=" + token), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)404, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs/" + this.manualDomain.getId() + "/cover?lastModified=" + lastUpdateCoverTime + "&r=" + token), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs/" + this.manualDomain.getId() + "/cover?lastModified=" + lastUpdateCoverTime + "&r=wrongToken"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)403, (int)response.getStatus());
    }

    @Test
    public void testGetProgramAvatarById() throws Exception {
        long lastUpdateAvatarTime = Utils.parseRFC3339Date((String)this.manualDomain.getLastModifiedDate()).getTime();
        String token = URLEncoder.encode(Utils.generateAttachmentToken((String)String.valueOf(this.manualDomain.getId()), (String)"avatar", (Long)lastUpdateAvatarTime), StandardCharsets.UTF_8);
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs/default-avatar/avatar?lastModified=" + lastUpdateAvatarTime + "&r=" + token), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs/155/avatar?lastModified=" + lastUpdateAvatarTime + "&r=" + token), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)404, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs/" + this.manualDomain.getId() + "/avatar?lastModified=" + lastUpdateAvatarTime + "&r=" + token), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs/" + this.manualDomain.getId() + "/avatar?lastModified=" + lastUpdateAvatarTime + "&r=wrongToken"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)403, (int)response.getStatus());
    }

    @Test
    public void testGetProgramById() throws Exception {
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs/0"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs/7580"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)404, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("programs/" + this.autoDomain.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramRestEntity savedDomain = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertNotNull((Object)savedDomain);
        TestProgramRest.assertEquals((long)this.autoDomain.getId(), (long)savedDomain.getId());
    }

    @Test
    public void testGetDisabledProgramOwners() throws Exception {
        ProgramEntity programEntity = this.newOpenProgram("openProgram");
        Identity owner1 = this.identityManager.getOrCreateUserIdentity("root53");
        Identity owner2 = this.identityManager.getOrCreateUserIdentity("root54");
        HashSet<Long> ownerIds = new HashSet<Long>(Arrays.asList(Long.parseLong(owner1.getId()), Long.parseLong(owner2.getId())));
        programEntity.setOwners(ownerIds);
        this.programDAO.update((Object)programEntity);
        this.restartTransaction();
        this.startSessionAsAdministrator("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramRestEntity savedProgram = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertNotNull((Object)savedProgram);
        TestProgramRest.assertEquals((long)programEntity.getId(), (long)savedProgram.getId());
        TestProgramRest.assertNotNull((Object)savedProgram.getOwners());
        TestProgramRest.assertEquals((int)2, (int)savedProgram.getOwners().size());
        TestProgramRest.assertEquals(ownerIds, (Object)savedProgram.getOwnerIds());
        owner2.setEnable(false);
        this.identityManager.updateIdentity(owner2);
        owner2 = this.identityManager.getOrCreateUserIdentity("root54");
        TestProgramRest.assertFalse((boolean)owner2.isEnable());
        response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        savedProgram = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertNotNull((Object)savedProgram);
        TestProgramRest.assertEquals((long)programEntity.getId(), (long)savedProgram.getId());
        TestProgramRest.assertNotNull((Object)savedProgram.getOwners());
        TestProgramRest.assertEquals((int)1, (int)savedProgram.getOwners().size());
        TestProgramRest.assertEquals(Collections.singleton(Long.parseLong(owner1.getId())), (Object)savedProgram.getOwnerIds());
    }

    @Test
    public void testGetOpenProgramById() throws Exception {
        ProgramEntity programEntity = this.newOpenProgram("openProgram");
        this.startSessionAsAdministrator("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramRestEntity savedProgram = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertNotNull((Object)savedProgram);
        TestProgramRest.assertEquals((long)programEntity.getId(), (long)savedProgram.getId());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isCanEdit());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isManager());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isMember());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isMember());
        this.startSessionAs("root10");
        response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        savedProgram = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertNotNull((Object)savedProgram);
        TestProgramRest.assertEquals((long)programEntity.getId(), (long)savedProgram.getId());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)savedProgram.getUserInfo()).isCanEdit());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)savedProgram.getUserInfo()).isManager());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isMember());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)savedProgram.getUserInfo()).isProgramOwner());
        this.startExternalSessionAs("root15");
        response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramDTO program = this.programService.getProgramById(programEntity.getId().longValue());
        program.setOwnerIds(Collections.singleton(Long.parseLong(this.identityManager.getOrCreateUserIdentity("root10").getId())));
        this.programService.updateProgram(program);
        this.startSessionAs("root10");
        response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        savedProgram = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertNotNull((Object)savedProgram);
        TestProgramRest.assertEquals((long)programEntity.getId(), (long)savedProgram.getId());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isCanEdit());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isManager());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isMember());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)savedProgram.getUserInfo()).isProgramOwner());
    }

    @Test
    public void testGetAccessibleProgramByIdByAnonymous() throws Exception {
        ProgramFilter filter = new ProgramFilter();
        filter.setStatus(EntityStatusType.ENABLED);
        TestProgramRest.assertEquals((int)0, (int)this.programService.getPrograms(filter, null, 0, 10).size());
        TestProgramRest.assertEquals((int)0, (int)this.programService.countPrograms(filter, null));
        ProgramEntity programEntity = this.newDomain(EntityType.AUTOMATIC, "testGetAccessibleProgramById", true, Collections.emptySet());
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)401, (int)response.getStatus());
        ProgramDTO program = this.programService.getProgramById(programEntity.getId().longValue());
        program.setSpaceId(Long.parseLong("200"));
        this.programService.updateProgram(program);
        response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramRestEntity programRestEntity = (ProgramRestEntity)response.getEntity();
        TestProgramRest.assertNotNull((Object)programRestEntity);
        TestProgramRest.assertEquals((long)programEntity.getId(), (long)programRestEntity.getId());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isCanView());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isCanEdit());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isManager());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isMember());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isProgramOwner());
    }

    @Test
    public void testGetAccessibleProgramsByAnonymous() throws Exception {
        ProgramFilter filter = new ProgramFilter();
        filter.setStatus(EntityStatusType.ENABLED);
        TestProgramRest.assertEquals((int)0, (int)this.programService.getPrograms(filter, null, 0, 10).size());
        TestProgramRest.assertEquals((int)0, (int)this.programService.countPrograms(filter, null));
        ProgramEntity programEntity = this.newDomain(EntityType.AUTOMATIC, "testGetAccessiblePrograms", true, Collections.emptySet());
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs?offset=0&limit=10&returnSize=true&expand=administrators"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        ProgramList programList = (ProgramList)response.getEntity();
        TestProgramRest.assertNotNull((Object)programList);
        TestProgramRest.assertNull((Object)programList.getAdministrators());
        TestProgramRest.assertEquals((int)0, (int)programList.getSize());
        TestProgramRest.assertEquals((int)0, (int)programList.getPrograms().size());
        ProgramDTO program = this.programService.getProgramById(programEntity.getId().longValue());
        program.setSpaceId(Long.parseLong("200"));
        this.programService.updateProgram(program);
        response = this.getResponse("GET", this.getURLResource("programs?offset=0&limit=10&returnSize=true"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        programList = (ProgramList)response.getEntity();
        TestProgramRest.assertNotNull((Object)programList);
        TestProgramRest.assertNotNull((Object)programList.getPrograms());
        TestProgramRest.assertEquals((int)1, (int)programList.getPrograms().size());
        TestProgramRest.assertEquals((int)1, (int)programList.getSize());
        ProgramRestEntity programRestEntity = (ProgramRestEntity)programList.getPrograms().get(0);
        TestProgramRest.assertNotNull((Object)programRestEntity);
        TestProgramRest.assertEquals((long)programEntity.getId(), (long)programRestEntity.getId());
        TestProgramRest.assertTrue((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isCanView());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isCanEdit());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isManager());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isMember());
        TestProgramRest.assertFalse((boolean)((UserInfoContext)programRestEntity.getUserInfo()).isProgramOwner());
    }

    @Test
    public void testGetAccessibleProgramsByAnonymousWhenRestrictedHubAccess() throws Exception {
        ProgramFilter filter = new ProgramFilter();
        filter.setStatus(EntityStatusType.ENABLED);
        TestProgramRest.assertEquals((int)0, (int)this.programService.getPrograms(filter, null, 0, 10).size());
        TestProgramRest.assertEquals((int)0, (int)this.programService.countPrograms(filter, null));
        this.newDomain(EntityType.AUTOMATIC, "testGetAccessibleProgramsByAnonymousWhenNotOpen", true, Collections.emptySet());
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs?offset=0&limit=10&returnSize=true"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        this.setRestrictedHubAccess();
        response = this.getResponse("GET", this.getURLResource("programs?offset=0&limit=10&returnSize=true"), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)401, (int)response.getStatus());
    }

    @Test
    public void testGetAccessibleProgramByIdByAnonymousWhenRestrictedHubAccess() throws Exception {
        ProgramEntity programEntity = this.newDomain(EntityType.AUTOMATIC, "testGetAccessibleProgramByIdByAnonymousWhenRestrictedHubAccess", true, Collections.emptySet());
        programEntity.setVisibility(EntityVisibility.OPEN);
        this.programDAO.update((Object)programEntity);
        ContainerResponse response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)200, (int)response.getStatus());
        this.setRestrictedHubAccess();
        response = this.getResponse("GET", this.getURLResource("programs/" + programEntity.getId()), null);
        TestProgramRest.assertNotNull((Object)response);
        TestProgramRest.assertEquals((int)401, (int)response.getStatus());
    }
}

