/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.service.RuleService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationActivityListener
extends ActivityListenerPlugin {
    protected static final String EXCLUDE_ACTIVITY_TYPES_PARAM = "exclude.activityTypes";
    protected static final String EXCLUDE_COMMENT_TYPES_PARAM = "exclude.commentTypes";
    private static final Log LOG = ExoLogger.getLogger(GamificationActivityListener.class);
    protected final RuleService ruleService;
    protected final IdentityManager identityManager;
    protected final SpaceService spaceService;
    protected final ActivityManager activityManager;
    protected final ListenerService listenerService;
    protected final List<String> excludedCommentTypes;
    protected final List<String> excludedActivityTypes;

    public GamificationActivityListener(RuleService ruleService, IdentityManager identityManager, ActivityManager activityManager, SpaceService spaceService, ListenerService listenerService, InitParams params) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.listenerService = listenerService;
        this.excludedActivityTypes = params.getValuesParam(EXCLUDE_ACTIVITY_TYPES_PARAM).getValues();
        this.excludedCommentTypes = params.getValuesParam(EXCLUDE_COMMENT_TYPES_PARAM).getValues();
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if (activity == null || activity.isHidden() || activity.isComment() || StringUtils.equals((CharSequence)activity.getType(), (CharSequence)"SPACE_ACTIVITY") || StringUtils.isNotBlank((CharSequence)activity.getType()) && this.excludedActivityTypes.contains(activity.getType())) {
            return;
        }
        this.createActivityGamificationHistoryEntry(activity.getPosterId(), activity.getStreamId(), "postActivity", activity.getId(), this.buildEventDetails(activity));
        Space space = this.getSpaceOfActivity(activity);
        if (space == null) {
            if (!StringUtils.equals((CharSequence)activity.getStreamId(), (CharSequence)activity.getPosterId())) {
                this.createActivityGamificationHistoryEntry(activity.getStreamId(), activity.getPosterId(), "receiveActivity", activity.getId(), this.buildEventDetails(activity));
            }
        } else if (space.getManagers() != null && space.getManagers().length > 0) {
            String[] spaceManagers;
            for (String spaceManager : spaceManagers = space.getManagers()) {
                Identity spaceManagerIdentity = this.identityManager.getOrCreateUserIdentity(spaceManager);
                if (spaceManagerIdentity == null || spaceManagerIdentity.isDeleted() || !spaceManagerIdentity.isEnable() || StringUtils.equals((CharSequence)spaceManagerIdentity.getId(), (CharSequence)activity.getPosterId())) continue;
                this.createActivityGamificationHistoryEntry(spaceManagerIdentity.getId(), activity.getPosterId(), "receiveActivity", activity.getId(), this.buildEventDetails(activity));
            }
        }
    }

    public void pinActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String userIdentityId = event.getUserId();
        this.createActivityGamificationHistoryEntry(userIdentityId, userIdentityId, "pinActivityOnSpace", activity.getId(), this.buildEventDetails(activity));
    }

    public void deleteActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        this.markActivityGamificationHistoryAsDeleted(activity.getId());
        Arrays.stream(activity.getReplyToId()).forEach(this::markActivityGamificationHistoryAsDeleted);
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        ExoSocialActivity parent = this.activityManager.getParentActivity(activity);
        if (parent == null || StringUtils.isNotBlank((CharSequence)activity.getType()) && this.excludedCommentTypes.contains(activity.getType())) {
            return;
        }
        this.createActivityGamificationHistoryEntry(activity.getPosterId(), parent.getPosterId(), "postActivityComment", activity.getId(), this.buildEventDetails(parent));
        this.createActivityGamificationHistoryEntry(parent.getPosterId(), activity.getPosterId(), "receiveCommentOnActivity", activity.getId(), this.buildEventDetails(parent));
        Space space = this.getSpaceOfActivity(parent);
        if (space != null) {
            this.createSpaceGamificationHistoryEntry(space.getPrettyName(), activity.getPosterId(), "postActivityComment", activity.getId(), this.buildEventDetails(parent));
        }
    }

    public void deleteComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        this.markActivityGamificationHistoryAsDeleted(activity.getId());
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String likerIdentityId = event.getUserId();
        if (StringUtils.equalsIgnoreCase((CharSequence)activity.getPosterId(), (CharSequence)likerIdentityId)) {
            return;
        }
        this.createActivityGamificationHistoryEntry(likerIdentityId, activity.getPosterId(), "likeActivity", activity.getId(), this.buildEventDetails(activity));
        this.createActivityGamificationHistoryEntry(activity.getPosterId(), likerIdentityId, "receiveLikeOnActivity", activity.getId(), this.buildEventDetails(activity));
        Space space = this.getSpaceOfActivity(activity);
        if (space != null) {
            this.createSpaceGamificationHistoryEntry(space.getPrettyName(), likerIdentityId, "likeActivity", activity.getId(), this.buildEventDetails(activity));
        }
    }

    public void deleteLikeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String likerIdentityId = event.getUserId();
        this.cancelActivityGamificationHistoryEntry(likerIdentityId, activity.getPosterId(), "likeActivity", activity.getId(), "activity");
        this.cancelActivityGamificationHistoryEntry(activity.getPosterId(), likerIdentityId, "receiveLikeOnActivity", activity.getId(), "activity");
        Space space = this.getSpaceOfActivity(activity);
        if (space != null) {
            this.cancelSpaceGamificationHistoryEntry(space.getPrettyName(), likerIdentityId, "likeActivity", activity.getId(), "activity");
        }
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        ExoSocialActivity parent = this.activityManager.getParentActivity(activity);
        String likerIdentityId = event.getUserId();
        if (StringUtils.equalsIgnoreCase((CharSequence)activity.getPosterId(), (CharSequence)likerIdentityId)) {
            return;
        }
        this.createActivityGamificationHistoryEntry(likerIdentityId, activity.getPosterId(), "likeActivityComment", activity.getId(), this.buildEventDetails(parent));
        this.createActivityGamificationHistoryEntry(activity.getPosterId(), likerIdentityId, "receiveLikeOnActivityComment", activity.getId(), this.buildEventDetails(parent));
        Space space = this.getSpaceOfActivity(activity);
        if (space != null) {
            this.createSpaceGamificationHistoryEntry(space.getPrettyName(), likerIdentityId, "likeActivityComment", activity.getId(), this.buildEventDetails(parent));
        }
    }

    public void deleteLikeComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String likerIdentityId = event.getUserId();
        this.cancelActivityGamificationHistoryEntry(likerIdentityId, activity.getPosterId(), "likeActivityComment", activity.getId(), "activity");
        this.cancelActivityGamificationHistoryEntry(activity.getPosterId(), likerIdentityId, "receiveLikeOnActivityComment", activity.getId(), "activity");
        Space space = this.getSpaceOfActivity(activity);
        if (space != null) {
            this.cancelSpaceGamificationHistoryEntry(space.getPrettyName(), likerIdentityId, "likeActivityComment", activity.getId(), "activity");
        }
    }

    private Space getSpaceOfActivity(ExoSocialActivity activity) {
        if (activity.getParentId() != null) {
            activity = this.activityManager.getParentActivity(activity);
        }
        return this.isSpaceActivity(activity) ? this.spaceService.getSpaceByPrettyName(activity.getActivityStream().getPrettyId()) : null;
    }

    private boolean isSpaceActivity(ExoSocialActivity activity) {
        return activity.getActivityStream() != null && ActivityStream.Type.SPACE.equals((Object)activity.getActivityStream().getType());
    }

    private void createActivityGamificationHistoryEntry(String earnerIdentityId, String receiverId, String gamificationEventName, String activityId, String eventDetails) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", activityId);
            gam.put("objectType", "activity");
            gam.put("senderId", earnerIdentityId);
            gam.put("receiverId", receiverId);
            gam.put("eventDetails", eventDetails);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }

    private void cancelActivityGamificationHistoryEntry(String earnerIdentityId, String receiverId, String gamificationEventName, String objectId, String objectType) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", objectId);
            gam.put("objectType", objectType);
            gam.put("senderId", earnerIdentityId);
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast("gamification.cancel.event.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }

    private void cancelSpaceGamificationHistoryEntry(String earnerIdentityId, String receiverId, String gamificationEventName, String objectId, String objectType) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", objectId);
            gam.put("objectType", objectType);
            gam.put("senderId", earnerIdentityId);
            gam.put("senderType", "space");
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast("gamification.cancel.event.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }

    private void createSpaceGamificationHistoryEntry(String spacePrettyName, String receiverId, String gamificationEventName, String activityId, String eventDetails) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", activityId);
            gam.put("objectType", "activity");
            gam.put("senderId", spacePrettyName);
            gam.put("senderType", "space");
            gam.put("receiverId", receiverId);
            gam.put("eventDetails", eventDetails);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }

    private void markActivityGamificationHistoryAsDeleted(String activityId) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("objectId", activityId);
            gam.put("objectType", "activity");
            this.listenerService.broadcast("gamification.delete.event.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }

    private String buildEventDetails(ExoSocialActivity activity) {
        String eventDetails;
        Space space = this.getSpaceOfActivity(activity);
        if (space != null) {
            String spaceId = space.getId();
            eventDetails = "{spaceId: " + spaceId + ", activityId: " + activity.getId() + "}";
        } else {
            eventDetails = "{activityId: " + activity.getId() + "}";
        }
        return eventDetails;
    }
}

