/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.rest.UserReputationEndpoint;
import io.meeds.gamification.test.AbstractServiceTest;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.junit.Before;
import org.junit.Test;

public class TestUserReputationEndpoint
extends AbstractServiceTest {
    protected Class<?> getComponentClass() {
        return UserReputationEndpoint.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startSessionAs("root1");
        this.registry(this.getComponentClass());
        ProgramEntity domainEntity = this.newDomain();
        this.newBadge(domainEntity.getId());
        this.newRealizationEntity("rule1", domainEntity.getId());
        this.newRealizationEntity("rule2", domainEntity.getId());
        this.newRealizationEntity("rule3", domainEntity.getId());
    }

    @Test
    public void testGetReputationStatus() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/status?username=root1"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetUserBadges() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/badges/1"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("reputation/badges"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetBadgeAvatarById() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/badge/5/avatar"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetAllBadges() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/won"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetOtherBadges() throws Exception {
        this.newBadgeWithScore();
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/otherBadges"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testStats() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/stats"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetAllOfBadges() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/AllofBadges"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }
}

