/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import java.util.HashMap;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Asynchronous
public class GamificationNotificationListener
extends Listener<String, UserSetting> {
    private static final Log LOG = ExoLogger.getLogger(GamificationNotificationListener.class);
    protected IdentityManager identityManager;
    protected ListenerService listenerService;

    public GamificationNotificationListener(IdentityManager identityManager, ListenerService listenerService) {
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<String, UserSetting> event) {
        String username = (String)event.getSource();
        Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (identity != null && !identity.isDeleted() && identity.isEnable()) {
            this.createRealizations(identity.getId());
        }
    }

    private void createRealizations(String identityId) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", "addUserProfileNotificationSetting");
            gam.put("objectId", identityId);
            gam.put("objectType", "identity");
            gam.put("senderId", identityId);
            gam.put("receiverId", identityId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }
}

