/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.dao.ConnectorAccountDAO;
import io.meeds.gamification.entity.ConnectorAccountEntity;
import io.meeds.gamification.storage.cached.ConnectorAccountCachedStorage;
import io.meeds.gamification.test.AbstractServiceTest;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ConnectorAccountStorageTest
extends AbstractServiceTest {
    @Mock
    CacheService cacheService;
    @Mock
    ConnectorAccountDAO connectorAccountDAO;
    ConnectorAccountCachedStorage connectorAccountStorage;

    @Override
    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.cacheService.getCacheInstance((String)ArgumentMatchers.any())).thenAnswer(invocation -> new ConcurrentFIFOExoCache((String)invocation.getArgument(0), 500));
        this.connectorAccountStorage = new ConnectorAccountCachedStorage(this.connectorAccountDAO, this.cacheService);
    }

    @Test
    public void TestDeleteConnectorAccount() {
        long connectorAccountId = 2L;
        ConnectorAccountEntity connectorAccountEntity = new ConnectorAccountEntity();
        connectorAccountEntity.setId(Long.valueOf(connectorAccountId));
        connectorAccountEntity.setConnectorName("connectorName");
        connectorAccountEntity.setUserId(2L);
        connectorAccountEntity.setRemoteId("connectorRemoteId");
        Mockito.when((Object)this.connectorAccountDAO.getConnectorAccountByNameAndRemoteId("connectorName", "connectorRemoteId")).thenReturn((Object)connectorAccountEntity);
        Mockito.when((Object)this.connectorAccountDAO.getConnectorRemoteId("connectorName", 2L)).thenReturn((Object)"connectorRemoteId");
        Mockito.when((Object)this.connectorAccountDAO.getAssociatedUserIdentityId("connectorName", "connectorRemoteId")).thenReturn((Object)2L);
        String remoteId = this.connectorAccountStorage.getConnectorRemoteId("connectorName", 2L);
        ConnectorAccountStorageTest.assertEquals((String)"connectorRemoteId", (String)remoteId);
        ((ConnectorAccountDAO)Mockito.verify((Object)this.connectorAccountDAO, (VerificationMode)Mockito.times((int)1))).getConnectorRemoteId("connectorName", 2L);
        long userId = this.connectorAccountStorage.getUserIdentityId("connectorName", "connectorRemoteId");
        ConnectorAccountStorageTest.assertEquals((long)2L, (long)userId);
        this.connectorAccountStorage.getConnectorRemoteId("connectorName", 2L);
        ((ConnectorAccountDAO)Mockito.verify((Object)this.connectorAccountDAO, (VerificationMode)Mockito.times((int)1))).getConnectorRemoteId("connectorName", 2L);
        this.connectorAccountStorage.deleteConnectorAccount("connectorName", "connectorRemoteId");
        ((ConnectorAccountDAO)Mockito.verify((Object)this.connectorAccountDAO, (VerificationMode)Mockito.times((int)1))).delete((Object)((ConnectorAccountEntity)ArgumentMatchers.any()));
        Mockito.when((Object)this.connectorAccountDAO.getConnectorRemoteId("connectorName", 2L)).thenReturn(null);
        Mockito.when((Object)this.connectorAccountDAO.getAssociatedUserIdentityId("connectorName", "connectorRemoteId")).thenReturn((Object)0L);
        this.connectorAccountStorage.getConnectorRemoteId("connectorName", 2L);
        ((ConnectorAccountDAO)Mockito.verify((Object)this.connectorAccountDAO, (VerificationMode)Mockito.times((int)2))).getConnectorRemoteId("connectorName", 2L);
        this.connectorAccountStorage.getUserIdentityId("connectorName", "connectorRemoteId");
        ((ConnectorAccountDAO)Mockito.verify((Object)this.connectorAccountDAO, (VerificationMode)Mockito.times((int)1))).getAssociatedUserIdentityId("connectorName", "connectorRemoteId");
    }
}

