/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest.model;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.UserInfo;
import io.meeds.gamification.rest.model.RealizationRestEntity;
import java.util.List;
import java.util.Set;

public class RuleRestEntity
extends RuleDTO {
    private static final long serialVersionUID = 5177522303947816474L;
    private long audience;
    private Set<Long> managers;
    private List<RealizationRestEntity> realizations;
    private long realizationsCount;
    private UserInfo userInfo;
    private List<RuleDTO> prerequisiteRules;
    private boolean published;
    private boolean favorite;

    public RuleRestEntity(Long id, String title, String description, int score, ProgramDTO program, boolean enabled, boolean deleted, String createdBy, String createdDate, String lastModifiedBy, EventDTO event, String lastModifiedDate, String startDate, String endDate, long activityId, long cacheTime, boolean published, boolean favorite, Set<Long> prerequisiteRuleIds, EntityType type, RecurrenceType recurrence, long audience, Set<Long> managers, List<RealizationRestEntity> realizations, long realizationsCount, UserInfo userInfo, List<RuleDTO> prerequisiteRules) {
        super(id, title, description, score, program, enabled, deleted, createdBy, createdDate, lastModifiedBy, event, lastModifiedDate, startDate, endDate, activityId, cacheTime, prerequisiteRuleIds, type, recurrence);
        this.published = published;
        this.favorite = favorite;
        this.audience = audience;
        this.managers = managers;
        this.realizations = realizations;
        this.realizationsCount = realizationsCount;
        this.userInfo = userInfo;
        this.prerequisiteRules = prerequisiteRules;
    }

    @Override
    public RuleRestEntity clone() {
        return new RuleRestEntity(this.id, this.title, this.description, this.score, this.program, this.enabled, this.deleted, this.createdBy, this.createdDate, this.lastModifiedBy, this.event, this.lastModifiedDate, this.startDate, this.endDate, this.activityId, this.cacheTime, this.published, this.favorite, this.prerequisiteRuleIds, this.type, this.recurrence, this.audience, this.managers, this.realizations, this.realizationsCount, this.userInfo, this.prerequisiteRules);
    }

    public RuleRestEntity() {
    }

    public long getAudience() {
        return this.audience;
    }

    @Override
    public Set<Long> getManagers() {
        return this.managers;
    }

    public List<RealizationRestEntity> getRealizations() {
        return this.realizations;
    }

    public long getRealizationsCount() {
        return this.realizationsCount;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public List<RuleDTO> getPrerequisiteRules() {
        return this.prerequisiteRules;
    }

    public boolean isPublished() {
        return this.published;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setAudience(long audience) {
        this.audience = audience;
    }

    public void setManagers(Set<Long> managers) {
        this.managers = managers;
    }

    public void setRealizations(List<RealizationRestEntity> realizations) {
        this.realizations = realizations;
    }

    public void setRealizationsCount(long realizationsCount) {
        this.realizationsCount = realizationsCount;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setPrerequisiteRules(List<RuleDTO> prerequisiteRules) {
        this.prerequisiteRules = prerequisiteRules;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleRestEntity)) {
            return false;
        }
        RuleRestEntity other = (RuleRestEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAudience() != other.getAudience()) {
            return false;
        }
        if (this.getRealizationsCount() != other.getRealizationsCount()) {
            return false;
        }
        if (this.isPublished() != other.isPublished()) {
            return false;
        }
        if (this.isFavorite() != other.isFavorite()) {
            return false;
        }
        Set<Long> this$managers = this.getManagers();
        Set<Long> other$managers = other.getManagers();
        if (this$managers == null ? other$managers != null : !((Object)this$managers).equals(other$managers)) {
            return false;
        }
        List<RealizationRestEntity> this$realizations = this.getRealizations();
        List<RealizationRestEntity> other$realizations = other.getRealizations();
        if (this$realizations == null ? other$realizations != null : !((Object)this$realizations).equals(other$realizations)) {
            return false;
        }
        UserInfo this$userInfo = this.getUserInfo();
        UserInfo other$userInfo = other.getUserInfo();
        if (this$userInfo == null ? other$userInfo != null : !((Object)this$userInfo).equals(other$userInfo)) {
            return false;
        }
        List<RuleDTO> this$prerequisiteRules = this.getPrerequisiteRules();
        List<RuleDTO> other$prerequisiteRules = other.getPrerequisiteRules();
        return !(this$prerequisiteRules == null ? other$prerequisiteRules != null : !((Object)this$prerequisiteRules).equals(other$prerequisiteRules));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RuleRestEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $audience = this.getAudience();
        result = result * 59 + (int)($audience >>> 32 ^ $audience);
        long $realizationsCount = this.getRealizationsCount();
        result = result * 59 + (int)($realizationsCount >>> 32 ^ $realizationsCount);
        result = result * 59 + (this.isPublished() ? 79 : 97);
        result = result * 59 + (this.isFavorite() ? 79 : 97);
        Set<Long> $managers = this.getManagers();
        result = result * 59 + ($managers == null ? 43 : ((Object)$managers).hashCode());
        List<RealizationRestEntity> $realizations = this.getRealizations();
        result = result * 59 + ($realizations == null ? 43 : ((Object)$realizations).hashCode());
        UserInfo $userInfo = this.getUserInfo();
        result = result * 59 + ($userInfo == null ? 43 : ((Object)$userInfo).hashCode());
        List<RuleDTO> $prerequisiteRules = this.getPrerequisiteRules();
        result = result * 59 + ($prerequisiteRules == null ? 43 : ((Object)$prerequisiteRules).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RuleRestEntity(super=" + super.toString() + ", audience=" + this.getAudience() + ", managers=" + this.getManagers() + ", realizations=" + this.getRealizations() + ", realizationsCount=" + this.getRealizationsCount() + ", userInfo=" + this.getUserInfo() + ", prerequisiteRules=" + this.getPrerequisiteRules() + ", published=" + this.isPublished() + ", favorite=" + this.isFavorite() + ")";
    }
}

