/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.cached;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.dao.ProgramDAO;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.storage.EventStorage;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.storage.cached.model.CacheKey;
import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class RuleCachedStorage
extends RuleStorage {
    private static final int RULE_ID_CONTEXT = 0;
    private static final int RULE_TITLE_CONTEXT = 1;
    private static final int RULES_BY_FILTER_CONTEXT = 3;
    private static final String RULE_CACHE_NAME = "gamification.rule";
    private FutureExoCache<Serializable, Object, CacheKey> ruleFutureCache;

    public RuleCachedStorage(ProgramStorage programStorage, EventStorage eventStorage, ProgramDAO programDAO, RuleDAO ruleDAO, CacheService cacheService) {
        super(programStorage, eventStorage, programDAO, ruleDAO);
        ExoCache ruleCache = cacheService.getCacheInstance(RULE_CACHE_NAME);
        Loader<Serializable, Object, CacheKey> ruleLoader = new Loader<Serializable, Object, CacheKey>(){

            public Object retrieve(CacheKey context, Serializable key) throws Exception {
                if (context.getContext() == 0) {
                    RuleDTO rule = RuleCachedStorage.super.findRuleById(context.getId());
                    if (rule != null) {
                        rule.setCacheTime(System.currentTimeMillis());
                    }
                    return rule;
                }
                if (context.getContext() == 1) {
                    return RuleCachedStorage.super.findRuleByTitle(context.getTitle());
                }
                if (context.getContext() == 3) {
                    return RuleCachedStorage.super.findRuleIdsByFilter(context.getRuleFilter(), context.getOffset(), context.getLimit());
                }
                throw new IllegalStateException("Unknown context id " + context);
            }
        };
        this.ruleFutureCache = new FutureExoCache((Loader)ruleLoader, ruleCache);
    }

    @Override
    public RuleDTO saveRule(RuleDTO ruleDTO) {
        try {
            RuleDTO ruleDTO2 = super.saveRule(ruleDTO);
            return ruleDTO2;
        }
        finally {
            if (EntityType.MANUAL.equals((Object)ruleDTO.getType())) {
                this.ruleFutureCache.clear();
            } else {
                this.clearCache(ruleDTO);
            }
        }
    }

    @Override
    public RuleDTO findRuleById(Long id) {
        CacheKey key = new CacheKey((Integer)0, id);
        RuleDTO ruleDTO = (RuleDTO)this.ruleFutureCache.get((Object)key, (Object)key.hashCode());
        return ruleDTO == null ? null : ruleDTO.clone();
    }

    @Override
    public RuleDTO findRuleByTitle(String title) {
        CacheKey key = new CacheKey((Integer)1, title);
        RuleDTO ruleDTO = (RuleDTO)this.ruleFutureCache.get((Object)key, (Object)key.hashCode());
        return ruleDTO == null ? null : ruleDTO.clone();
    }

    @Override
    public RuleDTO deleteRuleById(long ruleId, String userId) throws ObjectNotFoundException {
        RuleDTO rule = super.deleteRuleById(ruleId, userId);
        this.clearCache(rule);
        return rule;
    }

    @Override
    public void clearCache() {
        this.ruleFutureCache.clear();
    }

    @Override
    public void clearCache(RuleDTO rule) {
        this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)0, rule.getId()).hashCode()));
        this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)1, rule.getTitle()).hashCode()));
    }
}

