/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.analytics;

import io.meeds.gamification.analytics.AnalyticsRealizationListener;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import java.util.HashSet;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnalyticsRealizationListenerTest {
    private static final long AUDIENCE_ID = 1L;
    private static final long ACTIVITY_ID = 5L;
    private static final String RECEIVER = "receiver";
    private static final long USER_IDENTITY_ID = 2L;
    private static final long CHALLENGE_ID = 3L;
    private static final int SCORE = 1200;
    private static final String PROGRAM_DESCRIPTION = "programDescription";
    private static final String PROGRAM_TITLE = "programTitle";
    private static final String EVENT_NAME = "eventName";
    private static final String CHALLENGE_DESCRIPTION = "ChallengeDescription";
    private static final String CHALLENGE_TITLE = "challengeTitle";
    private static MockedStatic<AnalyticsUtils> ANALYTICS_UTILS;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private RuleService ruleService;
    @Mock
    private EventService eventService;
    @Mock
    private RealizationService realizationService;
    @Mock
    private Event<Object, Object> event;
    @Mock
    private Identity userIdentity;
    @Mock
    private Space space;
    private RuleDTO ruleDTO;
    private RealizationDTO realization;
    private AnalyticsRealizationListener realizationListener;

    @BeforeClass
    public static void initClassContext() {
        ANALYTICS_UTILS = Mockito.mockStatic(AnalyticsUtils.class);
    }

    @AfterClass
    public static void endClassContext() {
        ANALYTICS_UTILS.close();
    }

    @Before
    public void setup() {
        this.ruleDTO = this.newRule();
        this.realization = this.newRealization();
        ANALYTICS_UTILS.reset();
        ANALYTICS_UTILS.when(() -> AnalyticsUtils.addSpaceStatistics((StatisticData)((StatisticData)ArgumentMatchers.any()), (Space)((Space)ArgumentMatchers.any()))).thenCallRealMethod();
        Mockito.when((Object)this.event.getSource()).thenReturn((Object)this.realization);
        Mockito.when((Object)this.ruleService.findRuleById(3L)).thenReturn((Object)this.ruleDTO);
        this.realizationListener = new AnalyticsRealizationListener(this.ruleService, this.eventService, null, this.identityManager, this.spaceService);
    }

    @Test
    public void testThrowExceptionWhenUnhandledEvent() {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"UNHANDLED");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationListener.onEvent(this.event));
    }

    @Test
    public void testHandleCreateRuleEvent() throws Exception {
        this.assertCollectedOperation("realization.created", "createRealization");
    }

    @Test
    public void testHandleUpdateRuleEvent() throws Exception {
        this.assertCollectedOperation("realization.updated", "updateRealization");
    }

    @Test
    public void testHandleDeleteRuleEvent() throws Exception {
        this.assertCollectedOperation("realization.canceled", "cancelRealization");
    }

    private void assertCollectedOperation(String eventName, String expectedOperation) throws Exception {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)eventName);
        String spaceId = String.valueOf(1L);
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getId()).thenReturn((Object)spaceId);
        this.realizationListener.onEvent(this.event);
        ANALYTICS_UTILS.verify(() -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)ArgumentMatchers.argThat(statisticData -> {
            Assert.assertEquals((Object)"gamification", (Object)statisticData.getModule());
            Assert.assertEquals((Object)"realization", (Object)statisticData.getSubModule());
            Assert.assertEquals((Object)expectedOperation, (Object)statisticData.getOperation());
            Assert.assertEquals((long)2L, (long)statisticData.getUserId());
            Assert.assertEquals((long)1L, (long)statisticData.getSpaceId());
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getId()), (Object)String.valueOf(statisticData.getParameters().get("ruleId")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getTitle()), (Object)String.valueOf(statisticData.getParameters().get("ruleTitle")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getDescription()), (Object)String.valueOf(statisticData.getParameters().get("ruleDescription")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getEvent()), (Object)String.valueOf(statisticData.getParameters().get("ruleEvent")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getScore()), (Object)String.valueOf(statisticData.getParameters().get("ruleBudget")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getType()), (Object)String.valueOf(statisticData.getParameters().get("ruleType")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getProgram().getId()), (Object)String.valueOf(statisticData.getParameters().get("programId")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getProgram().getTitle()), (Object)String.valueOf(statisticData.getParameters().get(PROGRAM_TITLE)));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getProgram().getBudget()), (Object)String.valueOf(statisticData.getParameters().get("programBudget")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getProgram().getType()), (Object)String.valueOf(statisticData.getParameters().get("programType")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getProgram().getCoverFileId()), (Object)String.valueOf(statisticData.getParameters().get("programCoverFileId")));
            Assert.assertEquals((Object)String.valueOf(this.ruleDTO.getProgram().getOwnerIds()), (Object)String.valueOf(statisticData.getListParameters().get("programOwners")));
            return true;
        }))), Mockito.times((int)1));
    }

    private RealizationDTO newRealization() {
        this.realization = new RealizationDTO();
        this.realization.setRuleId(Long.valueOf(3L));
        this.realization.setEarnerId(String.valueOf(2L));
        this.realization.setEarnerType(IdentityType.USER.name());
        this.realization.setType(EntityType.MANUAL);
        this.realization.setStatus(RealizationStatus.ACCEPTED.name());
        this.realization.setActivityId(Long.valueOf(5L));
        this.realization.setReceiver(RECEIVER);
        return this.realization;
    }

    private RuleDTO newRule() {
        this.ruleDTO = new RuleDTO();
        this.ruleDTO.setId(Long.valueOf(3L));
        this.ruleDTO.setScore(1200);
        this.ruleDTO.setTitle(CHALLENGE_TITLE);
        this.ruleDTO.setDescription(CHALLENGE_DESCRIPTION);
        this.ruleDTO.setEnabled(true);
        this.ruleDTO.setDeleted(false);
        this.ruleDTO.setEvent(this.newEvent());
        this.ruleDTO.setProgram(this.newProgram());
        this.ruleDTO.setType(EntityType.MANUAL);
        return this.ruleDTO;
    }

    private ProgramDTO newProgram() {
        ProgramDTO program = new ProgramDTO();
        program.setTitle(PROGRAM_TITLE);
        program.setDescription(PROGRAM_DESCRIPTION);
        program.setDeleted(false);
        program.setEnabled(true);
        program.setType(EntityType.AUTOMATIC.name());
        program.setSpaceId(1L);
        HashSet<Long> owners = new HashSet<Long>();
        owners.add(1L);
        program.setOwnerIds(owners);
        return program;
    }

    private EventDTO newEvent() {
        EventDTO event = new EventDTO();
        event.setTitle(EVENT_NAME);
        event.setTrigger(EVENT_NAME);
        event.setType("eventType");
        return event;
    }
}

