/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;

public class RuleTranslationPluginTest
extends AbstractServiceTest {
    private final Identity adminAclIdentity = new Identity("root1", Arrays.asList(new MembershipEntry("/platform/administrators")));
    private TranslationService translationService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityRegistry.register(this.adminAclIdentity);
        this.translationService = (TranslationService)ExoContainerContext.getService(TranslationService.class);
    }

    public void testManageTranslations() throws IllegalAccessException, ObjectNotFoundException {
        RuleDTO rule = this.newRuleDTO();
        RuleTranslationPluginTest.assertNotNull((Object)rule);
        long ruleId = rule.getId();
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("rule", ruleId, "title", Collections.singletonMap(Locale.ENGLISH, "label"), "root2"));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.translationService.saveTranslationLabels("rule", 5555L, "title", Collections.singletonMap(Locale.ENGLISH, "label"), "root2"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels("rule", 0L, "title", Collections.singletonMap(Locale.ENGLISH, "label"), "root2"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels("rule", ruleId, null, Collections.singletonMap(Locale.ENGLISH, "label"), "root2"));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("rule", ruleId, "title", Collections.singletonMap(Locale.ENGLISH, "label"), null));
        this.translationService.saveTranslationLabels("rule", ruleId, "title", Collections.singletonMap(Locale.ENGLISH, "label"), this.adminAclIdentity.getUserId());
        TranslationField translationField = this.translationService.getTranslationField("rule", ruleId, "title", this.adminAclIdentity.getUserId());
        RuleTranslationPluginTest.assertNotNull((Object)translationField);
        RuleTranslationPluginTest.assertEquals((long)ruleId, (long)translationField.getObjectId());
        RuleTranslationPluginTest.assertEquals((String)"rule", (String)translationField.getObjectType());
        RuleTranslationPluginTest.assertEquals((String)((String)translationField.getLabels().get(Locale.ENGLISH)), (String)"label");
    }
}

