/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.analytics;

import io.meeds.gamification.analytics.AnalyticsAnnouncementListener;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import java.util.HashSet;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnalyticsAnnouncementListenerTest {
    private static final String ANNOUNCEMENT_COMMENT = "COMMENT";
    private static final long ANNOUNCEMENT_ID = 15L;
    private static final long ACTIVITY_ID = 22L;
    private static final long AUDIENCE_ID = 1L;
    private static final String USER_NAME = "userName";
    private static final long USER_IDENTITY_ID = 2L;
    private static final long CHALLENGE_ID = 3L;
    private static final int SCORE = 1200;
    private static final String PROGRAM_DESCRIPTION = "programDescription";
    private static final String PROGRAM_TITLE = "programTitle";
    private static final String EVENT_NAME = "eventName";
    private static final String CHALLENGE_DESCRIPTION = "ChallengeDescription";
    private static final String CHALLENGE_TITLE = "challengeTitle";
    private static MockedStatic<AnalyticsUtils> ANALYTICS_UTILS;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private RuleService ruleService;
    @Mock
    private Event<Announcement, Long> event;
    @Mock
    private Announcement announcement;
    @Mock
    private Identity userIdentity;
    @Mock
    private Space space;
    private AnalyticsAnnouncementListener announcementListener;

    @BeforeClass
    public static void initClassContext() {
        ANALYTICS_UTILS = Mockito.mockStatic(AnalyticsUtils.class);
    }

    @AfterClass
    public static void endClassContext() {
        ANALYTICS_UTILS.close();
    }

    @Before
    public void setup() {
        ANALYTICS_UTILS.reset();
        ANALYTICS_UTILS.when(() -> AnalyticsUtils.addSpaceStatistics((StatisticData)((StatisticData)ArgumentMatchers.any()), (Space)((Space)ArgumentMatchers.any()))).thenCallRealMethod();
        Mockito.when((Object)((Announcement)this.event.getSource())).thenReturn((Object)this.announcement);
        Mockito.when((Object)this.announcement.getId()).thenReturn((Object)15L);
        Mockito.when((Object)this.announcement.getActivityId()).thenReturn((Object)22L);
        Mockito.when((Object)this.announcement.getAssignee()).thenReturn((Object)2L);
        Mockito.when((Object)this.announcement.getComment()).thenReturn((Object)ANNOUNCEMENT_COMMENT);
        Mockito.when((Object)((Long)this.event.getData())).thenReturn((Object)2L);
        this.announcementListener = new AnalyticsAnnouncementListener(this.identityManager, this.spaceService, this.ruleService);
    }

    @Test
    public void testThrowExceptionWhenUnhandledEvent() {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"UNHANDLED");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.announcementListener.onEvent(this.event));
    }

    @Test
    public void testHandleCreateAnnouncementEvent() throws Exception {
        this.assertCollectedOperation("announcement.created", "createAnnouncement");
    }

    @Test
    public void testHandleUpdateAnnouncementEvent() throws Exception {
        this.assertCollectedOperation("announcement.updated", "updateAnnouncement");
    }

    private void assertCollectedOperation(String eventName, String expectedOperation) throws Exception {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)eventName);
        Mockito.when((Object)this.announcement.getChallengeId()).thenReturn((Object)3L);
        RuleDTO ruleDTO = this.newRule();
        Mockito.when((Object)this.ruleService.findRuleById(3L)).thenReturn((Object)ruleDTO);
        String identityId = String.valueOf(2L);
        Mockito.when((Object)this.identityManager.getIdentity(identityId)).thenReturn((Object)this.userIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USER_NAME)).thenReturn((Object)this.userIdentity);
        Mockito.when((Object)this.userIdentity.getRemoteId()).thenReturn((Object)USER_NAME);
        Mockito.when((Object)this.userIdentity.getId()).thenReturn((Object)identityId);
        String spaceId = String.valueOf(1L);
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getId()).thenReturn((Object)spaceId);
        this.announcementListener.onEvent(this.event);
        ANALYTICS_UTILS.verify(() -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)ArgumentMatchers.argThat(statisticData -> {
            Assert.assertEquals((Object)"gamification", (Object)statisticData.getModule());
            Assert.assertEquals((Object)"announcement", (Object)statisticData.getSubModule());
            Assert.assertEquals((Object)expectedOperation, (Object)statisticData.getOperation());
            Assert.assertEquals((long)2L, (long)statisticData.getUserId());
            Assert.assertEquals((long)1L, (long)statisticData.getSpaceId());
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getId()), (Object)String.valueOf(statisticData.getParameters().get("ruleId")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getTitle()), (Object)String.valueOf(statisticData.getParameters().get("ruleTitle")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getDescription()), (Object)String.valueOf(statisticData.getParameters().get("ruleDescription")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getScore()), (Object)String.valueOf(statisticData.getParameters().get("ruleBudget")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getType()), (Object)String.valueOf(statisticData.getParameters().get("ruleType")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getProgram().getId()), (Object)String.valueOf(statisticData.getParameters().get("programId")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getProgram().getTitle()), (Object)String.valueOf(statisticData.getParameters().get(PROGRAM_TITLE)));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getProgram().getBudget()), (Object)String.valueOf(statisticData.getParameters().get("programBudget")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getProgram().getType()), (Object)String.valueOf(statisticData.getParameters().get("programType")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getProgram().getCoverFileId()), (Object)String.valueOf(statisticData.getParameters().get("programCoverFileId")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getProgram().getAvatarFileId()), (Object)String.valueOf(statisticData.getParameters().get("programAvatarFileId")));
            Assert.assertEquals((Object)String.valueOf(ruleDTO.getProgram().getOwnerIds()), (Object)String.valueOf(statisticData.getListParameters().get("programOwners")));
            Assert.assertEquals((Object)String.valueOf(this.announcement.getId()), (Object)String.valueOf(statisticData.getParameters().get("announcementId")));
            Assert.assertEquals((Object)String.valueOf(this.announcement.getActivityId()), (Object)String.valueOf(statisticData.getParameters().get("announcementActivityId")));
            Assert.assertEquals((Object)String.valueOf(this.announcement.getAssignee()), (Object)String.valueOf(statisticData.getParameters().get("announcementAssignee")));
            Assert.assertEquals((Object)String.valueOf(this.announcement.getComment()), (Object)String.valueOf(statisticData.getParameters().get("announcementComment")));
            return true;
        }))), Mockito.times((int)1));
    }

    private RuleDTO newRule() {
        RuleDTO ruleDTO = new RuleDTO();
        ruleDTO.setId(Long.valueOf(3L));
        ruleDTO.setScore(1200);
        ruleDTO.setTitle(CHALLENGE_TITLE);
        ruleDTO.setDescription(CHALLENGE_DESCRIPTION);
        ruleDTO.setEnabled(true);
        ruleDTO.setDeleted(false);
        ruleDTO.setEvent(this.newEvent());
        ruleDTO.setProgram(this.newProgram());
        ruleDTO.setType(EntityType.MANUAL);
        return ruleDTO;
    }

    private ProgramDTO newProgram() {
        ProgramDTO program = new ProgramDTO();
        program.setTitle(PROGRAM_TITLE);
        program.setDescription(PROGRAM_DESCRIPTION);
        program.setDeleted(false);
        program.setEnabled(true);
        program.setType(EntityType.AUTOMATIC.name());
        program.setSpaceId(1L);
        HashSet<Long> owners = new HashSet<Long>();
        owners.add(1L);
        program.setOwnerIds(owners);
        return program;
    }

    private EventDTO newEvent() {
        EventDTO event = new EventDTO();
        event.setTitle(EVENT_NAME);
        event.setType("eventType");
        event.setTrigger(EVENT_NAME);
        return event;
    }
}

