/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.rest.AnnouncementRest;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.exoplatform.social.core.identity.model.Identity;
import org.json.JSONWriter;
import org.junit.Before;
import org.junit.Test;

public class TestAnnouncementRest
extends AbstractServiceTest {
    private static final long MILLIS_IN_A_DAY = 86400000L;
    private static final String START_DATE = Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() - 259200000L));
    private static final String END_DATE = Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() + 259200000L));
    private static final String DATE = Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis()));
    private static final String ANNOUNCEMENTS_REST_BASE_PATH = "/gamification/announcements";

    protected Class<?> getComponentClass() {
        return AnnouncementRest.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.registry(this.getComponentClass());
        ConversationState.setCurrent(null);
    }

    @Test
    public void testCreatAnnouncement() throws Exception {
        Identity identity = this.identityManager.getOrCreateUserIdentity("root1");
        long identityId = Long.parseLong(identity.getId());
        ConversationState conversationState = this.startSessionAs("root1");
        RuleDTO rule = this.newRuleDTO();
        ProgramDTO program = rule.getProgram();
        program.setOwnerIds(Collections.singleton(identityId));
        this.programService.updateProgram(program, conversationState.getIdentity());
        rule.setTitle("update challenge");
        rule.setDescription("challenge description");
        rule.setStartDate(START_DATE);
        rule.setEndDate(END_DATE);
        rule.setEnabled(true);
        rule.setScore(10);
        rule.setType(EntityType.MANUAL);
        rule = this.ruleService.updateRule(rule);
        String announcementRestPath = ANNOUNCEMENTS_REST_BASE_PATH;
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(announcementRestPath, null, 0, "POST", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        envctx.put(SecurityContext.class, (Object)new AbstractServiceTest.MockSecurityContext("root"));
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)"0").key("challengeId").value((Object)rule.getId()).key("assignee").value((Object)"1").key("challengeTitle").value((Object)"challengeTitle").key("comment").value((Object)"announcement comment").key("creator").value((Object)"root1").key("createdDate").value((Object)DATE).key("templateParams").value(new HashMap()).endObject();
        byte[] data = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        ContainerResponse response = this.launcher.service("POST", announcementRestPath, "", (Map)h, null, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)400, (int)response.getStatus());
        ConversationState.setCurrent(null);
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root2");
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)200, (int)response.getStatus());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)"100").key("challengeId").value(1000L).key("assignee").value((Object)"1").key("challengeTitle").value((Object)"challengeTitle").key("comment").value((Object)"announcement comment").key("creator").value((Object)"root1").key("createdDate").value((Object)DATE).key("templateParams").value(new HashMap()).endObject();
        data = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)400, (int)response.getStatus());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)"0").key("challengeId").value(1000L).key("assignee").value((Object)"1").key("comment").value((Object)"announcement comment").key("creator").value((Object)"root1").key("createdDate").value((Object)DATE).key("templateParams").value(new HashMap()).endObject();
        data = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)404, (int)response.getStatus());
    }

    @Test
    public void testCreatAnnouncementInOpenProgram() throws Exception {
        Identity identity = this.identityManager.getOrCreateUserIdentity("root1");
        long identityId = Long.parseLong(identity.getId());
        ConversationState conversationState = this.startSessionAs("root1");
        RuleDTO rule = this.newRuleDTO();
        ProgramDTO program = rule.getProgram();
        program.setOwnerIds(Collections.singleton(identityId));
        program.setOpen(true);
        this.programService.updateProgram(program, conversationState.getIdentity());
        rule.setTitle("update challenge");
        rule.setDescription("challenge description");
        rule.setStartDate(START_DATE);
        rule.setEndDate(END_DATE);
        rule.setEnabled(true);
        rule.setScore(10);
        rule.setType(EntityType.MANUAL);
        rule = this.ruleService.updateRule(rule);
        String announcementRestPath = ANNOUNCEMENTS_REST_BASE_PATH;
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(announcementRestPath, null, 0, "POST", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        envctx.put(SecurityContext.class, (Object)new AbstractServiceTest.MockSecurityContext("root"));
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)"0").key("challengeId").value((Object)rule.getId()).key("assignee").value((Object)"1").key("challengeTitle").value((Object)"challengeTitle").key("comment").value((Object)"announcement comment").key("creator").value((Object)"root1").key("createdDate").value((Object)DATE).key("templateParams").value(new HashMap()).endObject();
        byte[] data = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        ContainerResponse response = this.launcher.service("POST", announcementRestPath, "", (Map)h, null, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)400, (int)response.getStatus());
        ConversationState.setCurrent(null);
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root2");
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)200, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)200, (int)response.getStatus());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)"100").key("challengeId").value(1000L).key("assignee").value((Object)"1").key("challengeTitle").value((Object)"challengeTitle").key("comment").value((Object)"announcement comment").key("creator").value((Object)"root1").key("createdDate").value((Object)DATE).key("templateParams").value(new HashMap()).endObject();
        data = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)400, (int)response.getStatus());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)"0").key("challengeId").value(1000L).key("assignee").value((Object)"1").key("comment").value((Object)"announcement comment").key("creator").value((Object)"root1").key("createdDate").value((Object)DATE).key("templateParams").value(new HashMap()).endObject();
        data = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        response = this.launcher.service("POST", announcementRestPath, "", (Map)h, data, envctx);
        TestAnnouncementRest.assertNotNull((Object)response);
        TestAnnouncementRest.assertEquals((int)404, (int)response.getStatus());
    }
}

