/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.glpi.service;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.glpi.model.GLPISettings;
import org.exoplatform.glpi.service.GLPIService;
import org.exoplatform.glpi.service.GLPIServiceImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class GLPIServiceImplTest {
    @Mock
    private SettingService settingService;
    @Mock
    private HttpClient httpClient;
    private static final MockedStatic<EntityUtils> ENTITY_UTILS = Mockito.mockStatic(EntityUtils.class);
    private GLPIService glpiService;
    private static final Context GLPI_INTEGRATION_SETTING_CONTEXT = Context.GLOBAL.id("glpi-integration");
    private static final Scope GLPI_INTEGRATION_SETTING_SCOPE = Scope.APPLICATION.id("glpi-integration");
    private static final Context GLPI_USER_TOKEN_SETTING_CONTEXT = Context.USER.id("user");

    @Before
    public void setUp() throws Exception {
        this.glpiService = new GLPIServiceImpl(this.settingService);
        Field httpClient = this.glpiService.getClass().getDeclaredField("httpClient");
        httpClient.setAccessible(true);
        httpClient.set(this.glpiService, this.httpClient);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ENTITY_UTILS.close();
    }

    @Test
    public void saveGLPISettings() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.glpiService.saveGLPISettings(null, "token", 10));
        Assert.assertEquals((Object)"GLPI serverApiUrl is mandatory", (Object)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.glpiService.saveGLPISettings("url", null, 10));
        Assert.assertEquals((Object)"GLPI app token is mandatory", (Object)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.glpiService.saveGLPISettings("url", "token", 0));
        Assert.assertEquals((Object)"GLPI max Tickets to display should be between 1 and 10", (Object)exception.getMessage());
        GLPISettings glpiSettings = this.glpiService.saveGLPISettings("url", "token", 10);
        Assert.assertNotNull((Object)glpiSettings);
        Assert.assertEquals((Object)"url", (Object)glpiSettings.getServerApiUrl());
        Assert.assertEquals((Object)"token", (Object)glpiSettings.getAppToken());
        Assert.assertEquals((long)10L, (long)glpiSettings.getMaxTicketsToDisplay());
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)3))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (SettingValue)ArgumentMatchers.any());
    }

    @Test
    public void getGLPISettings() {
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationServerApiUrlSetting")).thenReturn(null);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationAppTokenSetting")).thenReturn(null);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationMaxDisplayTicketsSetting")).thenReturn(null);
        Assert.assertNull((Object)this.glpiService.getGLPISettings());
        SettingValue serverApiUrlSettingValue = SettingValue.create((String)"url");
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationServerApiUrlSetting")).thenReturn((Object)serverApiUrlSettingValue);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationAppTokenSetting")).thenReturn(null);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationMaxDisplayTicketsSetting")).thenReturn(null);
        Assert.assertNull((Object)this.glpiService.getGLPISettings());
        SettingValue appTokenSettingValue = SettingValue.create((String)"token");
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationServerApiUrlSetting")).thenReturn((Object)serverApiUrlSettingValue);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationAppTokenSetting")).thenReturn((Object)appTokenSettingValue);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationMaxDisplayTicketsSetting")).thenReturn(null);
        Assert.assertNull((Object)this.glpiService.getGLPISettings());
        SettingValue maxDisplayTicketsSettingValue = SettingValue.create((String)"10");
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationServerApiUrlSetting")).thenReturn((Object)serverApiUrlSettingValue);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationAppTokenSetting")).thenReturn((Object)appTokenSettingValue);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationMaxDisplayTicketsSetting")).thenReturn((Object)maxDisplayTicketsSettingValue);
        GLPISettings glpiSettings = this.glpiService.getGLPISettings();
        Assert.assertNotNull((Object)glpiSettings);
        Assert.assertEquals((Object)"url", (Object)glpiSettings.getServerApiUrl());
        Assert.assertEquals((Object)"token", (Object)glpiSettings.getAppToken());
        Assert.assertEquals((long)10L, (long)glpiSettings.getMaxTicketsToDisplay());
    }

    @Test
    public void saveUserToken() throws IOException {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.glpiService.saveUserToken(null, null));
        Assert.assertEquals((Object)"GLPI user token is mandatory", (Object)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.glpiService.saveUserToken("token", null));
        Assert.assertEquals((Object)"userIdentityId is mandatory", (Object)exception.getMessage());
        Assert.assertNotNull((Object)this.glpiService.saveUserToken("token", "user"));
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (SettingValue)ArgumentMatchers.any());
    }

    @Test
    public void getUserToken() {
        Mockito.when((Object)this.settingService.get(GLPI_USER_TOKEN_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIUserToken")).thenReturn(null);
        Assert.assertNull((Object)this.glpiService.getUserToken("user"));
        SettingValue userTokenSettingValue = SettingValue.create((String)"token");
        Mockito.when((Object)this.settingService.get(GLPI_USER_TOKEN_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIUserToken")).thenReturn((Object)userTokenSettingValue);
        Assert.assertNotNull((Object)this.glpiService.getUserToken("user"));
        Assert.assertEquals((Object)"token", (Object)this.glpiService.getUserToken("user"));
    }

    private void mockGetGLPISettingsAndUserToken() {
        SettingValue serverApiUrlSettingValue = SettingValue.create((String)"url");
        SettingValue appTokenSettingValue = SettingValue.create((String)"token");
        SettingValue maxDisplayTicketsSettingValue = SettingValue.create((String)"10");
        SettingValue userTokenSettingValue = SettingValue.create((String)"userToken");
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationServerApiUrlSetting")).thenReturn((Object)serverApiUrlSettingValue);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationAppTokenSetting")).thenReturn((Object)appTokenSettingValue);
        Mockito.when((Object)this.settingService.get(GLPI_INTEGRATION_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIIntegrationMaxDisplayTicketsSetting")).thenReturn((Object)maxDisplayTicketsSettingValue);
        Mockito.when((Object)this.settingService.get(GLPI_USER_TOKEN_SETTING_CONTEXT, GLPI_INTEGRATION_SETTING_SCOPE, "GLPIUserToken")).thenReturn((Object)userTokenSettingValue);
    }

    private void mockGetValidSessionTokenResponse(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)204);
        Mockito.when((Object)httpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
        ENTITY_UTILS.when(() -> EntityUtils.toString((HttpEntity)httpEntity)).thenReturn((Object)"{session_token: abc}");
    }

    @Test
    public void initSession() throws Exception {
        Method initSession = this.glpiService.getClass().getDeclaredMethod("initSession", String.class);
        initSession.setAccessible(true);
        String sessionToken = (String)initSession.invoke((Object)this.glpiService, "abc");
        Assert.assertNull((Object)sessionToken);
        this.mockGetGLPISettingsAndUserToken();
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.mockGetValidSessionTokenResponse(httpResponse);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)httpResponse);
        sessionToken = (String)initSession.invoke((Object)this.glpiService, "abc");
        Assert.assertEquals((Object)"abc", (Object)sessionToken);
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new HttpResponseException(401, "unauthorized")}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)initSession.invoke((Object)this.glpiService, "user"));
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)initSession.invoke((Object)this.glpiService, "user"));
    }

    private void mockGetValidKillSessionResponse(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)204);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
    }

    @Test
    public void killSession() throws Exception {
        Method killSession = this.glpiService.getClass().getDeclaredMethod("killSession", String.class);
        killSession.setAccessible(true);
        int statusCode = (Integer)killSession.invoke((Object)this.glpiService, "abc");
        Assert.assertEquals((long)400L, (long)statusCode);
        this.mockGetGLPISettingsAndUserToken();
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.mockGetValidKillSessionResponse(httpResponse);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)httpResponse);
        statusCode = (Integer)killSession.invoke((Object)this.glpiService, "user");
        Assert.assertEquals((long)204L, (long)statusCode);
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new HttpResponseException(401, "unauthorized")}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertEquals((Object)401, (Object)killSession.invoke((Object)this.glpiService, "user"));
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertEquals((Object)500, (Object)killSession.invoke((Object)this.glpiService, "user"));
    }

    @Test
    public void isUserTokenValid() throws IOException {
        Assert.assertFalse((boolean)this.glpiService.isUserTokenValid(null));
        Assert.assertFalse((boolean)this.glpiService.isUserTokenValid("token"));
        this.mockGetGLPISettingsAndUserToken();
        HttpResponse initSessionResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.mockGetValidSessionTokenResponse(initSessionResponse);
        HttpResponse killSessionResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.mockGetValidKillSessionResponse(initSessionResponse);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)initSessionResponse, (Object[])new HttpResponse[]{killSessionResponse});
        Assert.assertTrue((boolean)this.glpiService.isUserTokenValid("token"));
    }

    @Test
    public void getGLPIUserInfo() throws Exception {
        Method getGLPIUserInfo = this.glpiService.getClass().getDeclaredMethod("getGLPIUserInfo", Long.TYPE, String.class);
        getGLPIUserInfo.setAccessible(true);
        Assert.assertNull((Object)getGLPIUserInfo.invoke((Object)this.glpiService, 1L, "abc"));
        this.mockGetGLPISettingsAndUserToken();
        HttpResponse userInfoHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)204);
        Mockito.when((Object)userInfoHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)userInfoHttpResponse.getStatusLine()).thenReturn((Object)statusLine);
        ENTITY_UTILS.when(() -> EntityUtils.toString((HttpEntity)httpEntity)).thenReturn((Object)"{id: 1, name: user, firstname: first, realname:last}");
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)userInfoHttpResponse);
        Assert.assertNotNull((Object)getGLPIUserInfo.invoke((Object)this.glpiService, 1L, "abc"));
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new HttpResponseException(401, "unauthorized")}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)getGLPIUserInfo.invoke((Object)this.glpiService, 1L, "abc"));
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)getGLPIUserInfo.invoke((Object)this.glpiService, 1L, "abc"));
    }

    @Test
    public void getGLPITickets() throws Exception {
        Assert.assertNull((Object)this.glpiService.getGLPITickets(0, 3, null));
        this.mockGetGLPISettingsAndUserToken();
        HttpResponse initSessionResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.mockGetValidSessionTokenResponse(initSessionResponse);
        HttpResponse killSessionResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.mockGetValidKillSessionResponse(initSessionResponse);
        HttpResponse listTicketsHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)204);
        Mockito.when((Object)listTicketsHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)listTicketsHttpResponse.getStatusLine()).thenReturn((Object)statusLine);
        ENTITY_UTILS.when(() -> EntityUtils.toString((HttpEntity)httpEntity)).thenReturn((Object)"{data: [{\"21\":\"content\",\"17\":null,\"19\":\"2023-12-12 09:46:54\",\"12\":1,\"2\":3,\"25\":null,\"1\":\"title\",\"5\":[\"8\",\"7\"]}]}");
        Assert.assertNull((Object)this.glpiService.getGLPITickets(0, 3, "user"));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)initSessionResponse, (Object[])new HttpResponse[]{listTicketsHttpResponse, killSessionResponse});
        Assert.assertNotNull((Object)this.glpiService.getGLPITickets(0, 3, "user"));
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new HttpResponseException(401, "unauthorized")}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)this.glpiService.getGLPITickets(0, 3, "user"));
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)this.glpiService.getGLPITickets(0, 3, "user"));
    }

    @Test
    public void readTicketImageDocument() throws Exception {
        Assert.assertNull((Object)this.glpiService.readTicketImageDocument(1L, "root"));
        this.mockGetGLPISettingsAndUserToken();
        HttpResponse initSessionResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.mockGetValidSessionTokenResponse(initSessionResponse);
        HttpResponse killSessionResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.mockGetValidKillSessionResponse(initSessionResponse);
        HttpResponse readImageHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)204);
        Mockito.when((Object)readImageHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)readImageHttpResponse.getStatusLine()).thenReturn((Object)statusLine);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)httpEntity.getContent()).thenReturn((Object)inputStream);
        Mockito.when((Object)inputStream.readAllBytes()).thenReturn((Object)"test".getBytes());
        Assert.assertNull((Object)this.glpiService.readTicketImageDocument(1L, "user"));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)initSessionResponse, (Object[])new HttpResponse[]{readImageHttpResponse, killSessionResponse});
        Assert.assertNotNull((Object)this.glpiService.readTicketImageDocument(1L, "user"));
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new HttpResponseException(401, "unauthorized")}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)this.glpiService.readTicketImageDocument(1L, "user"));
        ((HttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.httpClient)).execute((HttpUriRequest)ArgumentMatchers.any());
        Assert.assertNull((Object)this.glpiService.readTicketImageDocument(1L, "user"));
    }

    @Test
    public void removeUserToken() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.glpiService.removeUserToken(null));
        Assert.assertEquals((Object)"user identity id is mandatory", (Object)exception.getMessage());
        this.glpiService.removeUserToken("user");
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).remove((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString());
    }
}

