/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.ixbus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.exoplatform.addons.ixbus.entity.DocumentEntity;
import org.exoplatform.addons.ixbus.entity.SettingsEntity;
import org.exoplatform.addons.ixbus.entity.StepEntity;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.json.JSONArray;
import org.json.JSONObject;

public class IxbusConnectorService {
    private static final String IXBUS_SERVICE_API = "ixbus";
    private final HttpClient httpClient;
    private String serverUrl = "";
    private String apiKey = "";
    protected final Log LOG = ExoLogger.getLogger(IxbusConnectorService.class);
    private String currentSessionToken = null;
    private long timeStampCreationSessionToken = 0L;
    private long sessionTokenLiveTime = 86400L;
    private Map<String, String> userIdentifiers;
    private static final int DEFAULT_POOL_CONNECTION = 100;
    private OrganizationService organizationService;

    public IxbusConnectorService(InitParams params, OrganizationService organizationService) {
        if (params.getValueParam("serverUrl") != null) {
            this.serverUrl = params.getValueParam("serverUrl").getValue();
        }
        if (params.getValueParam("apiKey") != null) {
            this.apiKey = params.getValueParam("apiKey").getValue();
        }
        if (this.serverUrl.isEmpty() || this.apiKey.isEmpty()) {
            this.LOG.error((Object)"IxbusConnector service is not correctly configured. Check serverUrl and apiKey.");
        }
        this.userIdentifiers = new HashMap<String, String>();
        this.organizationService = organizationService;
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(100);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy()).setMaxConnPerRoute(100).setRedirectStrategy(new RedirectStrategy(this){

            public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
                return null;
            }
        });
        this.httpClient = httpClientBuilder.build();
    }

    private void createSessionToken() {
        if (this.currentSessionToken == null || System.currentTimeMillis() - this.timeStampCreationSessionToken > this.sessionTokenLiveTime * 1000L) {
            try {
                this.timeStampCreationSessionToken = System.currentTimeMillis();
                JSONObject jsonResponse = this.doPost(this.serverUrl + "/api/jeton/creer?validiteEnSecondes=" + this.sessionTokenLiveTime, this.apiKey);
                if (jsonResponse.has("payload")) {
                    this.currentSessionToken = jsonResponse.getString("payload");
                    this.LOG.debug("Session Token created : {}, at timestamp {}", new Object[]{this.currentSessionToken, this.timeStampCreationSessionToken});
                }
            }
            catch (HttpResponseException e) {
                this.LOG.error("remote_service={} operation={} parameters=\"apiKey:{}\", status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{IXBUS_SERVICE_API, "createSessionToken", this.apiKey, System.currentTimeMillis() - this.timeStampCreationSessionToken, e.getReasonPhrase(), e.getStatusCode(), e});
                this.timeStampCreationSessionToken = 0L;
                this.currentSessionToken = null;
            }
            catch (IOException e) {
                this.LOG.error((Object)"Error while trying to create a session token", (Throwable)e);
                this.timeStampCreationSessionToken = 0L;
                this.currentSessionToken = null;
            }
        }
    }

    public String getUserIdentifier(String username) {
        return this.getUserIdentifier(username, true);
    }

    private String getUserIdentifier(String username, boolean canReplay) {
        String userIdentifier = this.userIdentifiers.get(username);
        if (userIdentifier == null) {
            User user = null;
            try {
                user = this.organizationService.getUserHandler().findUserByName(username);
            }
            catch (Exception e) {
                this.LOG.error("Unable to find user {}", new Object[]{username, e});
            }
            if (user != null) {
                this.createSessionToken();
                long startTime = System.currentTimeMillis();
                try {
                    JSONObject jsonResponse = this.doGet(this.serverUrl + "/api/parapheur/v1/utilisateur?email=" + user.getEmail(), this.currentSessionToken);
                    if (jsonResponse.has("payload") && !jsonResponse.getJSONArray("payload").isEmpty()) {
                        userIdentifier = jsonResponse.getJSONArray("payload").getJSONObject(0).getString("identifiant");
                        this.LOG.debug("User identifier found for username={} : idenfier={}", new Object[]{username, userIdentifier});
                        this.userIdentifiers.put(username, userIdentifier);
                    } else if (jsonResponse.has("payload")) {
                        this.LOG.warn("No Ixbus user founded corresponding to user={} with email={}", new Object[]{username, user.getEmail()});
                    }
                }
                catch (HttpResponseException e) {
                    if (e.getStatusCode() == 302 && canReplay) {
                        this.currentSessionToken = null;
                        this.timeStampCreationSessionToken = 0L;
                        return this.getUserIdentifier(username, false);
                    }
                    this.LOG.error("remote_service={} operation={} parameters=\"username:{}\", status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{IXBUS_SERVICE_API, "getUserIdentifier", username, System.currentTimeMillis() - startTime, e.getReasonPhrase(), e.getStatusCode(), e});
                }
                catch (IOException e) {
                    this.LOG.error((Object)"Error while trying to get user identifier", (Throwable)e);
                }
            }
        }
        return userIdentifier;
    }

    public Map<String, String> getAllUsers() {
        return this.getAllUsers(true);
    }

    private Map<String, String> getAllUsers(boolean canReplay) {
        HashMap<String, String> results = new HashMap<String, String>();
        this.createSessionToken();
        long startTime = System.currentTimeMillis();
        try {
            JSONObject jsonResponse = this.doGet(this.serverUrl + "/api/parapheur/v1/utilisateur", this.currentSessionToken);
            if (jsonResponse.has("payload") && !jsonResponse.getJSONArray("payload").isEmpty()) {
                JSONArray users = jsonResponse.getJSONArray("payload");
                for (int i = 0; i < users.length(); ++i) {
                    JSONObject user = users.getJSONObject(i);
                    results.put(user.getString("identifiant"), user.getString("email"));
                }
            }
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 302 && canReplay) {
                this.currentSessionToken = null;
                this.timeStampCreationSessionToken = 0L;
                return this.getAllUsers(false);
            }
            this.LOG.error("remote_service={} operation={} parameters=\"\", status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{IXBUS_SERVICE_API, "getAllUsers", System.currentTimeMillis() - startTime, e.getReasonPhrase(), e.getStatusCode(), e});
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error while trying to get all users", (Throwable)e);
        }
        return results;
    }

    private JSONObject doGet(String url, String token) throws IOException {
        HttpGet httpUserRequest = new HttpGet(url);
        httpUserRequest.setHeader("IXBUS_API", token);
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpUserRequest);
        String responseString = new BasicResponseHandler().handleResponse(httpResponse);
        EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        return new JSONObject(responseString);
    }

    private JSONObject doPost(String url, String token) throws IOException {
        HttpPost httpSessionRequest = new HttpPost(url);
        httpSessionRequest.setHeader("IXBUS_API", token);
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpSessionRequest);
        String responseString = new BasicResponseHandler().handleResponse(httpResponse);
        EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        return new JSONObject(responseString);
    }

    public int getUserFoldersCount(String username) {
        return this.getUserFoldersCount(username, true);
    }

    private int getUserFoldersCount(String username, boolean canReplay) {
        String userIdentifier = this.getUserIdentifier(username);
        if (userIdentifier != null) {
            this.createSessionToken();
            long startTime = System.currentTimeMillis();
            try {
                JSONObject jsonResponse = this.doGet(this.serverUrl + "/api/parapheur/v1/dossier/compteur?idUtilisateur=" + userIdentifier, this.currentSessionToken);
                if (jsonResponse.has("payload") && jsonResponse.getJSONObject("payload").has("nbDossiers")) {
                    int result = jsonResponse.getJSONObject("payload").getInt("nbDossiers");
                    this.LOG.debug("Found {} folders that {} own", new Object[]{result, username});
                    return result;
                }
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 302 && canReplay) {
                    this.currentSessionToken = null;
                    this.timeStampCreationSessionToken = 0L;
                    return this.getUserFoldersCount(username, false);
                }
                this.LOG.error("remote_service={} operation={} parameters=\"username:{}\", status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{IXBUS_SERVICE_API, "getUserFolderCount", username, System.currentTimeMillis() - startTime, e.getReasonPhrase(), e.getStatusCode(), e});
            }
            catch (IOException e) {
                this.LOG.error((Object)"Error while getting user folders count", (Throwable)e);
            }
        }
        return 0;
    }

    public List<DocumentEntity> getUserFolders(String username) {
        return this.getUserFolders(username, true);
    }

    private List<DocumentEntity> getUserFolders(String username, boolean canReplay) {
        ArrayList<DocumentEntity> result = new ArrayList<DocumentEntity>();
        String userIdentifier = this.getUserIdentifier(username);
        if (userIdentifier != null) {
            this.createSessionToken();
            long startTime = System.currentTimeMillis();
            try {
                JSONObject jsonResponse = this.doGet(this.serverUrl + "/api/parapheur/v1/dossier/emis?statutUtilisateur=redacteur&idUtilisateur=" + userIdentifier, this.currentSessionToken);
                if (jsonResponse.has("payload")) {
                    JSONArray folders = jsonResponse.getJSONArray("payload");
                    folders.forEach(folder -> {
                        if (!((JSONObject)folder).getString("statut").equals("Annule") && !((JSONObject)folder).getString("statut").equals("Cloture")) {
                            DocumentEntity document = this.toDocumentEntity((JSONObject)folder);
                            document.setTargetUrl(this.serverUrl + "/parapheur/suivi");
                            result.addFirst(document);
                        }
                    });
                    this.LOG.debug("Found {} folders that {} own", new Object[]{result.size(), username});
                    return result;
                }
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 302 && canReplay) {
                    this.currentSessionToken = null;
                    this.timeStampCreationSessionToken = 0L;
                    return this.getUserFolders(username, false);
                }
                this.LOG.error("remote_service={} operation={} parameters=\"username:{}\", status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{IXBUS_SERVICE_API, "getUserFolders", username, System.currentTimeMillis() - startTime, e.getReasonPhrase(), e.getStatusCode(), e});
                return null;
            }
            catch (IOException e) {
                this.LOG.error((Object)"Error while getting user folders", (Throwable)e);
                return null;
            }
        }
        return result;
    }

    public int getUserActionsCount(String username) {
        return this.getUserActionsCount(username, true);
    }

    private int getUserActionsCount(String username, boolean canReplay) {
        String userIdentifier = this.getUserIdentifier(username);
        if (userIdentifier != null) {
            this.createSessionToken();
            long startTime = System.currentTimeMillis();
            try {
                JSONObject jsonResponse = this.doGet(this.serverUrl + "/api/parapheur/v1/dossier/compteur?idUtilisateur=" + userIdentifier, this.currentSessionToken);
                if (jsonResponse.has("payload") && jsonResponse.getJSONObject("payload").has("nbDossiers")) {
                    int result = jsonResponse.getJSONObject("payload").getInt("nbDossiers");
                    this.LOG.debug("Found {} folders that {} must do", new Object[]{result, username});
                    return result;
                }
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 302 && canReplay) {
                    this.currentSessionToken = null;
                    this.timeStampCreationSessionToken = 0L;
                    return this.getUserActionsCount(username, false);
                }
                this.LOG.error("remote_service={} operation={} parameters=\"username:{}\", status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{IXBUS_SERVICE_API, "getUserActionsCount", username, System.currentTimeMillis() - startTime, e.getReasonPhrase(), e.getStatusCode(), e});
            }
            catch (IOException e) {
                this.LOG.error((Object)"Error while getting user actions count", (Throwable)e);
            }
        }
        return 0;
    }

    public List<DocumentEntity> getUserActions(String username) {
        return this.getUserActions(username, true);
    }

    private List<DocumentEntity> getUserActions(String username, boolean canReplay) {
        ArrayList<DocumentEntity> result = new ArrayList<DocumentEntity>();
        String userIdentifier = this.getUserIdentifier(username);
        if (userIdentifier != null) {
            this.createSessionToken();
            long startTime = System.currentTimeMillis();
            try {
                JSONObject jsonResponse = this.doGet(this.serverUrl + "/api/parapheur/v1/dossier?idUtilisateur=" + userIdentifier, this.currentSessionToken);
                if (jsonResponse.has("payload")) {
                    JSONArray folders = jsonResponse.getJSONArray("payload");
                    folders.forEach(folder -> {
                        DocumentEntity document = this.toDocumentEntity((JSONObject)folder);
                        result.addFirst(document);
                    });
                    this.LOG.debug("Found {} folders that {} must do", new Object[]{result.size(), username});
                    return result;
                }
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 302 && canReplay) {
                    this.currentSessionToken = null;
                    this.timeStampCreationSessionToken = 0L;
                    return this.getUserActions(username, false);
                }
                this.LOG.error("remote_service={} operation={} parameters=\"username:{}\", status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{IXBUS_SERVICE_API, "getUserActions", username, System.currentTimeMillis() - startTime, e.getReasonPhrase(), e.getStatusCode(), e});
            }
            catch (IOException e) {
                this.LOG.error((Object)"Error while getting user actions", (Throwable)e);
            }
        }
        return result;
    }

    public List<DocumentEntity> getFoldersInStatut(String statut) {
        return this.getFoldersInStatut(statut, true);
    }

    private List<DocumentEntity> getFoldersInStatut(String statut, boolean canReplay) {
        ArrayList<DocumentEntity> result = new ArrayList<DocumentEntity>();
        this.createSessionToken();
        long startTime = System.currentTimeMillis();
        try {
            JSONObject jsonResponse = this.doGet(this.serverUrl + "/api/parapheur/v1/dossier/tous?statut=" + statut, this.currentSessionToken);
            if (jsonResponse.has("payload")) {
                JSONArray folders = jsonResponse.getJSONArray("payload");
                folders.forEach(folder -> {
                    DocumentEntity document = this.toDocumentEntity((JSONObject)folder);
                    result.addFirst(document);
                });
                this.LOG.debug("Found {} folders in state {}", new Object[]{result.size(), statut});
                return result;
            }
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 302 && canReplay) {
                this.currentSessionToken = null;
                this.timeStampCreationSessionToken = 0L;
                return this.getFoldersInStatut(statut, false);
            }
            this.LOG.error("remote_service={} operation={} parameters=\"statut:{}\", status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{IXBUS_SERVICE_API, "getUserFoldersWithStatut", statut, System.currentTimeMillis() - startTime, e.getReasonPhrase(), e.getStatusCode(), e});
        }
        catch (IOException e) {
            this.LOG.error("Error while getting folders with statut={}", new Object[]{statut, e});
        }
        return result;
    }

    private DocumentEntity toDocumentEntity(JSONObject folder) {
        DocumentEntity document = new DocumentEntity();
        document.setId(folder.getString("identifiant"));
        document.setName(folder.getString("nom"));
        if (folder.has("actionAttendue") && !folder.isNull("actionAttendue")) {
            document.setAction(folder.getString("actionAttendue"));
            document.setTargetUrl(this.serverUrl + "/parapheur/" + folder.getString("actionAttendue"));
        }
        document.setCreationDate(folder.getString("dateCreation"));
        document.setStatus(folder.getString("statut"));
        if (folder.has("dateLimite") && !folder.isNull("dateLimite")) {
            document.setDueDate(folder.getString("dateLimite"));
        }
        document.setReferentFirstName(folder.getJSONObject("referent").getString("prenom"));
        document.setReferentLastName(folder.getJSONObject("referent").getString("nom"));
        document.setNature(folder.getJSONObject("nature").getString("nom"));
        if (folder.has("etapeEnCours") && !folder.isNull("etapeEnCours")) {
            JSONObject etape = folder.getJSONObject("etapeEnCours");
            StepEntity stepEntity = this.toStepEntity(etape);
            document.setStepEnAttente(stepEntity);
        }
        return document;
    }

    private StepEntity toStepEntity(JSONObject etape) {
        StepEntity step = new StepEntity();
        step.setIdentifiant(etape.getString("identifiantCible"));
        step.setStatut(etape.getString("type"));
        if (etape.has("dateEnAttente") && !etape.isNull("dateEnAttente")) {
            step.setDateEnAttente(etape.getString("dateEnAttente"));
        }
        return step;
    }

    public SettingsEntity getSettings() {
        SettingsEntity settings = new SettingsEntity();
        settings.setCreateUrl(this.serverUrl + "/parapheur/preparer");
        settings.setHistoryUrl(this.serverUrl + "/parapheur/historique");
        return settings;
    }
}

