/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.ixbus.notification;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.springframework.beans.factory.annotation.Autowired;

public class IxbusPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.IxbusPwaNotificationPlugin.title";
    private static final String BODY_LABEL_KEY = "pwa.notification.IxbusPwaNotificationPlugin.body";
    @Autowired
    private ResourceBundleService resourceBundleService;

    public String getId() {
        return "IxbusNotificationPlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", notification.getValueOwnerParameter("documentName")).replace("{1}", notification.getValueOwnerParameter("status")));
        notificationMessage.setBody(this.resourceBundleService.getSharedString(BODY_LABEL_KEY, localeConfig.getLocale()) + " : " + notification.getValueOwnerParameter("nature"));
        notificationMessage.setUrl(notification.getValueOwnerParameter("targetUrl"));
        return notificationMessage;
    }
}

