/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.ixbus;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.addons.ixbus.IxbusConnectorService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/ixbus")
public class IxBusRestService
implements ResourceContainer {
    private IxbusConnectorService ixbusConnectorService;

    public IxBusRestService(IxbusConnectorService ixbusConnectorService) {
        this.ixbusConnectorService = ixbusConnectorService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/folders")
    @Produces(value={"application/json"})
    @Operation(summary="Get current user folders", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCurrentUserFolders() {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok(this.ixbusConnectorService.getUserFolders(currentUser)).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/folders/count")
    @Produces(value={"application/json"})
    @Operation(summary="Get current user folders count", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCurrentUserFoldersCount() {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        int count = this.ixbusConnectorService.getUserFoldersCount(currentUser);
        return Response.ok((Object)("{\"count\":" + count + "}")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/actions")
    @Produces(value={"application/json"})
    @Operation(summary="Get current user actions", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCurrentUserActions() {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok(this.ixbusConnectorService.getUserActions(currentUser)).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/actions/count")
    @Produces(value={"application/json"})
    @Operation(summary="Get current user actions count", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCurrentUserActionsCount() {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        int count = this.ixbusConnectorService.getUserActionsCount(currentUser);
        return Response.ok((Object)("{\"count\":" + count + "}")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/settings")
    @Produces(value={"application/json"})
    @Operation(summary="Get ixbus settings", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSettings() {
        return Response.ok((Object)this.ixbusConnectorService.getSettings()).build();
    }
}

