/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.jwt;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.filter.Filter;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.security.Credentials;
import org.json.JSONObject;

public class JwtFilter
implements Filter {
    private static final String DEFAULT_AUTHORIZATION_HEADER = "Authorization";
    protected final Log LOG = ExoLogger.getLogger(JwtFilter.class);
    private String jwtHeaderName;
    private String jwtParameterName;
    private boolean jwtRedirectIfAnonym;
    private String jwtRedirectUrl;
    private List<String> exclusionsUrl = new ArrayList<String>();

    public JwtFilter() {
        this.jwtHeaderName = PropertyManager.getProperty((String)"exo.jwt.header");
        this.jwtParameterName = PropertyManager.getProperty((String)"exo.jwt.parameter");
        this.jwtRedirectUrl = PropertyManager.getProperty((String)"exo.jwt.redirectUrl");
        String exclusions = PropertyManager.getProperty((String)"exo.jwt.redirect.exclusions");
        if (exclusions != null) {
            this.exclusionsUrl.addAll(Arrays.asList(exclusions.split(",")));
        } else {
            this.exclusionsUrl.add("/portal/rest/onlyoffice/editor/status/");
            this.exclusionsUrl.add("/portal/rest/onlyoffice/editor/content/");
        }
        this.jwtRedirectIfAnonym = Boolean.parseBoolean(PropertyManager.getProperty((String)"exo.jwt.redirectIfAnonym"));
        if (this.jwtHeaderName == null && this.jwtParameterName == null) {
            this.jwtHeaderName = DEFAULT_AUTHORIZATION_HEADER;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String userId = httpRequest.getRemoteUser();
        if (userId == null) {
            Object authorizationToken = "";
            if (this.jwtHeaderName != null) {
                authorizationToken = httpRequest.getHeader(this.jwtHeaderName);
            } else if (this.jwtParameterName != null) {
                authorizationToken = httpRequest.getParameter(this.jwtParameterName);
            }
            if (authorizationToken != null) {
                String username;
                if (!((String)authorizationToken).startsWith("Bearer ")) {
                    authorizationToken = "Bearer " + (String)authorizationToken;
                }
                if ((username = this.extractUsername((String)authorizationToken)) != null) {
                    ServletContainer servletContainer = ServletContainerFactory.getServletContainer();
                    Credentials credentials = new Credentials(username, (String)authorizationToken);
                    try {
                        servletContainer.login(httpRequest, (HttpServletResponse)servletResponse, credentials);
                    }
                    catch (AuthenticationException ae) {
                        this.LOG.error("Unable to authenticate user with jwt token {}", new Object[]{authorizationToken});
                    }
                }
            }
            if (this.jwtRedirectIfAnonym && !this.exclusionsUrl.stream().anyMatch(s -> httpRequest.getRequestURI().startsWith((String)s))) {
                String authenticatedUser = httpRequest.getRemoteUser();
                this.LOG.info("user found after authentication = {}", new Object[]{authenticatedUser});
                if (authenticatedUser == null) {
                    HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
                    httpResponse.sendRedirect(this.jwtRedirectUrl);
                    return;
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String extractUsername(String jwtToken) {
        try {
            String[] split = jwtToken.split("\\.");
            String payload = new String(Base64.getUrlDecoder().decode(split[1]));
            JSONObject jsonPayload = new JSONObject(payload);
            return jsonPayload.getString("sub");
        }
        catch (Exception e) {
            this.LOG.warn("Unable to decode JWT Token {}", new Object[]{jwtToken});
            return null;
        }
    }
}

