/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.j2ee.TomcatLoginModule;

public class JwtLoginModule
extends TomcatLoginModule {
    protected final Log log = ExoLogger.getLogger(JwtLoginModule.class);
    private String jwtIssuer = PropertyManager.getProperty((String)"exo.jwt.issuer");
    private String jwtAudience = PropertyManager.getProperty((String)"exo.jwt.audience");
    private String jwtPublicKeyUrl = PropertyManager.getProperty((String)"exo.jwt.publicKeyUrl");
    private String jwtPublicKeyContent;

    public JwtLoginModule() {
        if (this.jwtIssuer == null) {
            this.jwtIssuer = PropertyManager.getProperty((String)"exo.base.url");
        }
        if (this.jwtAudience == null) {
            this.jwtAudience = PropertyManager.getProperty((String)"exo.base.url");
        }
        this.loadPublicKeyContent();
    }

    private void loadPublicKeyContent() {
        try (InputStream is = new URI(this.jwtPublicKeyUrl).toURL().openStream();){
            this.jwtPublicKeyContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            this.jwtPublicKeyContent = this.jwtPublicKeyContent.replace("\r\n", "").replace("\n", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
            LOG.debug("Public key founded : {}", new Object[]{this.jwtPublicKeyContent});
        }
        catch (Exception e) {
            this.log.error("Unable to load keystore {}", new Object[]{this.jwtPublicKeyUrl, e});
            this.jwtPublicKeyContent = "";
        }
    }

    protected Log getLogger() {
        return this.log;
    }

    public boolean login() throws LoginException {
        try {
            if (this.sharedState.containsKey("exo.security.identity")) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Use Identity from previous LoginModule");
                }
                this.identity = (Identity)this.sharedState.get("exo.security.identity");
            } else {
                Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
                this.callbackHandler.handle(callbacks);
                String jwtToken = new String(((PasswordCallback)callbacks[1]).getPassword());
                ((PasswordCallback)callbacks[1]).clearPassword();
                if (jwtToken.startsWith("Bearer ")) {
                    long startTime = System.currentTimeMillis();
                    String username = this.validateToken(jwtToken);
                    this.log.debug("Time to validate token in jwtLoginModule : {} ms", new Object[]{System.currentTimeMillis() - startTime});
                    if (username != null) {
                        this.searchUser(username);
                        Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
                        this.identity = authenticator.createIdentity(username);
                        this.sharedState.put("javax.security.auth.login.name", username);
                        this.sharedState.put("exo.security.identity", this.identity);
                        this.subject.getPublicCredentials().add(new UsernameCredential(username));
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage(), (Throwable)e);
            } else if (this.log.isWarnEnabled()) {
                this.log.warn((Object)e.getMessage());
            }
            throw new LoginException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchUser(String username) throws Exception {
        OrganizationService organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.begin(organizationService);
        try {
            UserHandler uHandler = organizationService.getUserHandler();
            User user = uHandler.findUserByName(username, UserStatus.ANY);
            if (user == null) {
                this.log.debug("user {0} doesn't exists. JwtLoginModule will be ignored.", new Object[]{username});
                throw new LoginException("Can't authenticate. user " + username + " does not exist");
            }
            if (!user.isEnabled()) {
                throw new LoginException("Can't authenticate. user " + username + " is disabled");
            }
        }
        finally {
            this.end(organizationService);
        }
    }

    public boolean commit() throws LoginException {
        if (this.identity != null) {
            super.commit();
        }
        return true;
    }

    private String validateToken(String authorization) throws LoginException {
        try {
            authorization = authorization.substring("Bearer ".length()).trim();
            if (this.jwtPublicKeyContent.isEmpty()) {
                this.loadPublicKeyContent();
            }
            KeyFactory kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.getDecoder().decode(this.jwtPublicKeyContent));
            RSAPublicKey pubKey = (RSAPublicKey)kf.generatePublic(keySpecX509);
            Claims claims = (Claims)Jwts.parserBuilder().setSigningKey((Key)pubKey).requireIssuer(this.jwtIssuer).requireAudience(this.jwtAudience).setAllowedClockSkewSeconds(10L).build().parseClaimsJws(authorization).getBody();
            return claims.getSubject();
        }
        catch (Exception e) {
            this.log.error("Unable to validate jwt token {}", new Object[]{authorization, e});
            throw new LoginException("Unable to validate jwt token");
        }
    }

    private void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            ComponentRequestLifecycle componentRequestLifecycle = (ComponentRequestLifecycle)orgService;
            RequestLifeCycle.begin((ComponentRequestLifecycle)componentRequestLifecycle);
        }
    }

    private void end(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

