/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.dao;

import java.time.YearMonth;
import java.time.ZoneOffset;
import java.util.List;
import javax.persistence.TypedQuery;
import org.exoplatform.addon.kudos.entity.KudosEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class KudosDAO
extends GenericDAOJPAImpl<KudosEntity, Long> {
    public void deleteAll() {
        throw new IllegalStateException("Kudos removal is disabled");
    }

    public void delete(KudosEntity entity) {
        throw new IllegalStateException("Kudos removal is disabled");
    }

    public void deleteAll(List<KudosEntity> entities) {
        throw new IllegalStateException("Kudos removal is disabled");
    }

    public List<KudosEntity> getAllKudosByMonth(YearMonth yearMonth) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getAllKudosByMonth", KudosEntity.class);
        this.setMonthParameters(query, yearMonth);
        return query.getResultList();
    }

    public List<KudosEntity> getAllKudosByMonthAndEntityType(YearMonth yearMonth, int entityType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getAllKudosByMonthAndEntityType", KudosEntity.class);
        this.setMonthParameters(query, yearMonth);
        query.setParameter("entityType", (Object)entityType);
        return query.getResultList();
    }

    public List<KudosEntity> getAllKudosByEntity(int entityType, long entityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getAllKudosByEntity", KudosEntity.class);
        query.setParameter("entityId", (Object)entityId);
        query.setParameter("entityType", (Object)entityType);
        return query.getResultList();
    }

    public List<KudosEntity> getKudosByMonthAndReceiver(YearMonth yearMonth, long receiverId, boolean isReceiverUser) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByMonthAndReceiver", KudosEntity.class);
        this.setMonthParameters(query, yearMonth);
        query.setParameter("receiverId", (Object)receiverId);
        query.setParameter("isReceiverUser", (Object)isReceiverUser);
        return query.getResultList();
    }

    public List<KudosEntity> getKudosByMonthAndSender(YearMonth yearMonth, long senderId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByMonthAndSender", KudosEntity.class);
        this.setMonthParameters(query, yearMonth);
        query.setParameter("senderId", (Object)senderId);
        return query.getResultList();
    }

    public long countKudosByMonthAndSender(YearMonth yearMonth, long senderId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.countKudosByMonthAndSender", Long.class);
        this.setMonthParameters(query, yearMonth);
        query.setParameter("senderId", (Object)senderId);
        return (Long)query.getSingleResult();
    }

    private void setMonthParameters(TypedQuery<?> query, YearMonth yearMonth) {
        long monthStartTimeInSeconds = yearMonth.atDay(1).atStartOfDay(ZoneOffset.systemDefault()).toEpochSecond();
        long monthEndTimeInSeconds = yearMonth.atEndOfMonth().atStartOfDay(ZoneOffset.systemDefault()).toEpochSecond();
        query.setParameter("startDate", (Object)monthStartTimeInSeconds);
        query.setParameter("endDate", (Object)monthEndTimeInSeconds);
    }
}

