/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.kudos.dao.KudosDAO;
import org.exoplatform.kudos.entity.KudosEntity;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosEntityType;
import org.exoplatform.kudos.model.KudosPeriod;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;

public class KudosStorage {
    private static final Log LOG = ExoLogger.getLogger(KudosStorage.class);
    private KudosDAO kudosDAO;
    private IdentityManager identityManager;

    public KudosStorage(KudosDAO kudosDAO) {
        this.kudosDAO = kudosDAO;
    }

    public Kudos getKudoById(long id) {
        KudosEntity kudosEntity = (KudosEntity)this.kudosDAO.find(Long.valueOf(id));
        if (kudosEntity == null) {
            LOG.warn("Can't find Kudos with id {}", new Object[]{id});
            return null;
        }
        return Utils.fromEntity(kudosEntity);
    }

    public Kudos createKudos(Kudos kudos) {
        KudosEntity kudosEntity = Utils.toNewEntity(kudos);
        kudosEntity = (KudosEntity)this.kudosDAO.create(kudosEntity);
        return Utils.fromEntity(kudosEntity);
    }

    public void saveKudosActivityId(long kudosId, long activityId) {
        KudosEntity kudosEntity = (KudosEntity)this.kudosDAO.find(Long.valueOf(kudosId));
        if (kudosEntity == null) {
            throw new IllegalStateException("Can't find Kudos with id " + kudosId);
        }
        kudosEntity.setActivityId(activityId);
        this.kudosDAO.update(kudosEntity);
    }

    public List<Kudos> getKudosByPeriod(KudosPeriod kudosPeriod, int limit) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.getKudosByPeriod(kudosPeriod, limit);
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public List<Kudos> getKudosByEntity(String entityType, String entityId, int limit) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.getKudosByEntity(KudosEntityType.valueOf(entityType).ordinal(), Long.parseLong(entityId), limit);
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public long countKudosByEntity(String entityType, String entityId) {
        return this.kudosDAO.countKudosByEntity(KudosEntityType.valueOf(entityType).ordinal(), Long.parseLong(entityId));
    }

    public long countKudosByPeriodAndReceiver(KudosPeriod kudosPeriod, String receiverType, String receiverId) {
        boolean isReceiverUser = "user".equals(receiverType) || "organization".equals(receiverType);
        Identity identity = this.getIdentityManager().getOrCreateIdentity(isReceiverUser ? "organization" : "space", receiverId);
        return this.kudosDAO.countKudosByPeriodAndReceiver(kudosPeriod, Long.parseLong(identity.getId()), isReceiverUser);
    }

    public List<Kudos> getKudosByPeriodAndReceiver(KudosPeriod kudosPeriod, String receiverType, String receiverId, int limit) {
        boolean isReceiverUser = "user".equals(receiverType) || "organization".equals(receiverType);
        long identityId = this.getIdentityId(receiverId, isReceiverUser);
        if (identityId <= 0L) {
            return Collections.emptyList();
        }
        List<KudosEntity> kudosEntities = this.kudosDAO.getKudosByPeriodAndReceiver(kudosPeriod, identityId, isReceiverUser, limit);
        if (kudosEntities != null) {
            ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
            return kudosList;
        }
        return Collections.emptyList();
    }

    public List<Kudos> getKudosByPeriodAndSender(KudosPeriod kudosPeriod, long senderIdentityId, int limit) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.getKudosByPeriodAndSender(kudosPeriod, senderIdentityId, limit);
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public long countKudosByPeriodAndSender(KudosPeriod kudosPeriod, long senderIdentityId) {
        return this.kudosDAO.countKudosByPeriodAndSender(kudosPeriod, senderIdentityId);
    }

    private long getIdentityId(String remoteId, boolean isReceiverUser) {
        long identityId = 0L;
        if (isReceiverUser) {
            Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", remoteId);
            if (identity == null) {
                return 0L;
            }
            identityId = Long.parseLong(identity.getId());
        } else {
            Space space = Utils.getSpace(remoteId);
            if (space == null) {
                return 0L;
            }
            identityId = Long.parseLong(space.getId());
        }
        return identityId;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        }
        return this.identityManager;
    }
}

