/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.listener;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.model.KudosEntityType;
import org.exoplatform.addon.kudos.service.KudosService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.processor.I18NActivityUtils;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.notification.Utils;

public class NewKudosSentActivityGeneratorListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(NewKudosSentActivityGeneratorListener.class);
    private ActivityManager activityManager;
    private ActivityStorage activityStorage;

    public NewKudosSentActivityGeneratorListener(ActivityManager activityManager, ActivityStorage activityStorage) {
        this.activityStorage = activityStorage;
        this.activityManager = activityManager;
    }

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        KudosService kudosService = (KudosService)event.getSource();
        if (KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.ACTIVITY || KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT) {
            String activityId = kudos.getEntityId();
            try {
                String parentCommentId = null;
                ExoSocialActivity activity = null;
                if (KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT) {
                    ExoSocialActivity comment = this.activityManager.getActivity("comment" + activityId);
                    if (comment != null) {
                        activity = this.activityManager.getParentActivity(comment);
                        parentCommentId = comment.getParentCommentId() != null ? comment.getParentCommentId() : comment.getId();
                    }
                } else {
                    activity = this.activityManager.getActivity(activityId);
                }
                if (activity == null) {
                    throw new IllegalStateException("Activity with id '" + activityId + "' wasn't found");
                }
                ExoSocialActivity activityComment = this.createActivity(kudos, parentCommentId);
                this.activityStorage.saveComment(activity, activityComment);
                kudosService.saveKudosActivity(kudos.getTechnicalId(), this.getActivityId(activityComment.getId()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Error adding comment on activity with id '" + activityId + "' for Kudos with id " + kudos.getTechnicalId()), (Throwable)e);
            }
        } else {
            Identity owner;
            ExoSocialActivity activity = this.createActivity(kudos, null);
            String providerId = "organization";
            if ("space".equals(kudos.getReceiverType()) || "space".equals(kudos.getReceiverType())) {
                providerId = "space";
            }
            if ((owner = Utils.getIdentityManager().getOrCreateIdentity(providerId, kudos.getReceiverId(), true)) == null) {
                LOG.warn("Can't find receiver identity with type/id", new Object[]{kudos.getReceiverType(), kudos.getReceiverId()});
            } else {
                this.activityStorage.saveActivity(owner, activity);
                kudosService.saveKudosActivity(kudos.getTechnicalId(), this.getActivityId(activity.getId()));
            }
        }
    }

    private ExoSocialActivity createActivity(Kudos kudos, String parentCommentId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType("exokudos:activity");
        activity.setTitle("Kudos to " + kudos.getReceiverFullName());
        activity.setUserId(kudos.getSenderIdentityId());
        activity.setParentCommentId(parentCommentId);
        String senderLink = "<a href='" + kudos.getSenderURL() + "'>" + kudos.getSenderFullName() + "</a>";
        senderLink = StringEscapeUtils.unescapeHtml((String)senderLink);
        String receiverLink = "<a href='" + kudos.getReceiverURL() + "'>" + kudos.getReceiverFullName() + "</a>";
        receiverLink = StringEscapeUtils.unescapeHtml((String)receiverLink);
        String message = StringUtils.isBlank((CharSequence)kudos.getMessage()) ? "." : ": " + StringEscapeUtils.escapeHtml((String)kudos.getMessage());
        I18NActivityUtils.addResourceKeyToProcess((ExoSocialActivity)activity, (String)"activity_kudos_content");
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"activity_kudos_content", (String[])new String[]{senderLink, receiverLink, message, "<i class='uiIcon fa fa-award uiIconKudos uiIconBlue'></i>"});
        return activity;
    }

    private Long getActivityId(String commentId) {
        return commentId == null || commentId.trim().isEmpty() ? null : Long.valueOf(commentId.replace("comment", ""));
    }
}

