/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosEntityType;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;

public class NewKudosSentActivityGeneratorListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(NewKudosSentActivityGeneratorListener.class);
    private ActivityStorage activityStorage;
    private ActivityManager activityManager;

    public NewKudosSentActivityGeneratorListener(ActivityManager activityManager, ActivityStorage activityStorage) {
        this.activityManager = activityManager;
        this.activityStorage = activityStorage;
    }

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        KudosService kudosService = (KudosService)event.getSource();
        if (KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.ACTIVITY || KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT) {
            String activityId = kudos.getEntityId();
            try {
                String parentCommentId = null;
                ExoSocialActivity activity = null;
                if (KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT) {
                    ExoSocialActivity comment = this.activityManager.getActivity(activityId);
                    if (comment != null) {
                        activity = this.activityManager.getParentActivity(comment);
                        parentCommentId = comment.getParentCommentId() != null ? comment.getParentCommentId() : comment.getId();
                    }
                } else {
                    activity = this.activityManager.getActivity(activityId);
                }
                if (activity == null) {
                    throw new IllegalStateException("Activity with id '" + activityId + "' wasn't found");
                }
                ExoSocialActivity activityComment = this.createActivity(kudos, parentCommentId);
                this.activityManager.saveComment(activity, activityComment);
                long commentId = Utils.getActivityId(activityComment.getId());
                kudos.setActivityId(commentId);
                kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId(), kudos.getActivityId());
                if (this.activityStorage instanceof CachedActivityStorage) {
                    ((CachedActivityStorage)this.activityStorage).clearActivityCached(activity.getId());
                    ((CachedActivityStorage)this.activityStorage).clearActivityCached(activityComment.getId());
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error adding comment on activity with id '" + activityId + "' for Kudos with id " + kudos.getTechnicalId()), (Throwable)e);
            }
        } else {
            Identity owner;
            ExoSocialActivity activity = this.createActivity(kudos, null);
            String providerId = "organization";
            String remoteId = kudos.getReceiverId();
            boolean isSpaceActivity = StringUtils.isNotBlank((CharSequence)kudos.getSpacePrettyName());
            if ("space".equals(kudos.getReceiverType()) || isSpaceActivity) {
                providerId = "space";
                if (isSpaceActivity) {
                    remoteId = kudos.getSpacePrettyName();
                }
            }
            if ((owner = org.exoplatform.social.notification.Utils.getIdentityManager().getOrCreateIdentity(providerId, remoteId)) == null) {
                LOG.warn("Can't find receiver identity with type/id", new Object[]{kudos.getReceiverType(), remoteId});
            } else {
                this.activityManager.saveActivityNoReturn(owner, activity);
                kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId(), Utils.getActivityId(activity.getId()));
                if (this.activityStorage instanceof CachedActivityStorage) {
                    ((CachedActivityStorage)this.activityStorage).clearActivityCached(activity.getId());
                }
            }
        }
    }

    private ExoSocialActivity createActivity(Kudos kudos, String parentCommentId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setParentCommentId(parentCommentId);
        activity.setType("exokudos:activity");
        activity.setTitle("Kudos to " + kudos.getReceiverFullName());
        activity.setBody("Kudos to " + kudos.getReceiverFullName());
        activity.setUserId(kudos.getSenderIdentityId());
        Utils.computeKudosActivityProperties((ExoSocialActivity)activity, kudos);
        return activity;
    }
}

