/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.layoutmanagement.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.layoutmanagement.rest.model.NodeLabelRestEntity;
import org.exoplatform.layoutmanagement.rest.model.PageTemplateRestEntity;
import org.exoplatform.layoutmanagement.rest.model.SiteRestEntity;
import org.exoplatform.layoutmanagement.utils.SiteNavigationUtils;
import org.exoplatform.portal.mop.State;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.gatein.api.Util;
import org.gatein.api.security.Permission;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteType;

public class EntityBuilder {
    private static final Log LOG = ExoLogger.getLogger(EntityBuilder.class);

    private EntityBuilder() {
    }

    public static PageTemplateRestEntity toPageTemplateRestEntity(SelectItemOption<String> pageTemplate, Locale userLocal) {
        if (pageTemplate == null) {
            return null;
        }
        return new PageTemplateRestEntity(SiteNavigationUtils.getI18NLabel(userLocal, pageTemplate.getLabel()), (String)pageTemplate.getValue());
    }

    public static List<PageTemplateRestEntity> toPageTemplateRestEntities(List<SelectItemOption<String>> pageTemplates, Locale userLocal) {
        return pageTemplates.stream().map(pageTemplate -> EntityBuilder.toPageTemplateRestEntity((SelectItemOption<String>)pageTemplate, userLocal)).toList();
    }

    public static NodeLabelRestEntity toNodeLabelRestEntity(Map<Locale, State> nodeLabels) {
        LocaleConfigService localeConfigService = (LocaleConfigService)CommonsUtils.getService(LocaleConfigService.class);
        Locale defaultLocale = localeConfigService.getDefaultLocaleConfig() == null ? Locale.ENGLISH : localeConfigService.getDefaultLocaleConfig().getLocale();
        String defaultLanguage = defaultLocale.getLanguage();
        Map<String, String> supportedLanguages = localeConfigService.getLocalConfigs() == null ? Collections.singletonMap(defaultLocale.getLanguage(), defaultLocale.getDisplayName()) : localeConfigService.getLocalConfigs().stream().filter(localeConfig -> !StringUtils.equals((CharSequence)localeConfig.getLocaleName(), (CharSequence)"ma")).collect(Collectors.toMap(LocaleConfig::getLocaleName, localeConfig -> localeConfig.getLocale().getDisplayName()));
        HashMap<String, String> localized = new HashMap<String, String>();
        NodeLabelRestEntity nodeLabelRestEntity = new NodeLabelRestEntity();
        if (nodeLabels != null && nodeLabels.size() != 0) {
            for (Map.Entry<Locale, State> entry : nodeLabels.entrySet()) {
                Locale locale = entry.getKey();
                State state = entry.getValue();
                localized.put(I18N.toTagIdentifier((Locale)locale), state.getName());
            }
            if (!nodeLabels.containsKey(defaultLocale)) {
                localized.put(I18N.toTagIdentifier((Locale)defaultLocale), null);
            }
            nodeLabelRestEntity.setLabels(localized);
        }
        nodeLabelRestEntity.setDefaultLanguage(defaultLanguage);
        nodeLabelRestEntity.setSupportedLanguages(supportedLanguages);
        return nodeLabelRestEntity;
    }

    public static SiteRestEntity toSiteRestEntity(Site site) {
        if (site == null) {
            return null;
        }
        org.exoplatform.portal.mop.SiteType siteType = Util.from((SiteType)site.getType());
        String displayName = site.getDisplayName();
        Identity userIdentity = ConversationState.getCurrent().getIdentity();
        if (org.exoplatform.portal.mop.SiteType.GROUP.equals((Object)siteType)) {
            try {
                Group siteGroup = EntityBuilder.getOrganizationService().getGroupHandler().findGroupById(site.getName());
                if (siteGroup == null || !userIdentity.isMemberOf(siteGroup.getId())) {
                    return null;
                }
                if (StringUtils.isBlank((CharSequence)displayName)) {
                    displayName = siteGroup.getLabel();
                }
            }
            catch (Exception e) {
                LOG.error("Error while retrieving group with name ", new Object[]{site.getName(), e});
            }
        }
        List<Map<String, Object>> accessPermissions = EntityBuilder.computePermissions(Util.from((Permission)site.getAccessPermission()));
        Map<String, Object> editPermission = EntityBuilder.computePermission(Util.from((Permission)site.getEditPermission())[0]);
        return new SiteRestEntity(site.getId(), siteType, site.getName(), !StringUtils.isBlank((CharSequence)displayName) ? displayName : site.getName(), site.getDescription(), accessPermissions, editPermission);
    }

    public static List<SiteRestEntity> toSiteRestEntities(List<Site> sites) {
        return sites.stream().map(site -> EntityBuilder.toSiteRestEntity(site)).filter(Objects::nonNull).toList();
    }

    private static OrganizationService getOrganizationService() {
        return (OrganizationService)CommonsUtils.getService(OrganizationService.class);
    }

    private static Map<String, Object> computePermission(String permission) {
        HashMap<String, Object> accessPermission = new HashMap<String, Object>();
        try {
            accessPermission.put("membershipType", permission.split(":")[0]);
            accessPermission.put("group", EntityBuilder.getOrganizationService().getGroupHandler().findGroupById(permission.split(":")[1]));
        }
        catch (Exception e) {
            LOG.error("Error while computing user permission ", new Object[]{permission, e});
        }
        return accessPermission;
    }

    private static List<Map<String, Object>> computePermissions(String[] permissions) {
        return Arrays.stream(permissions).map(EntityBuilder::computePermission).toList();
    }
}

