/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.layoutmanagement.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Comparator;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.layoutmanagement.rest.EntityBuilder;
import org.exoplatform.layoutmanagement.rest.model.SiteRestEntity;
import org.exoplatform.layoutmanagement.utils.SiteManagementUtils;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.gatein.api.Portal;
import org.gatein.api.Util;
import org.gatein.api.common.Filter;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteQuery;
import org.gatein.api.site.SiteType;

@Path(value="v1/sites")
@Tag(name="v1/sites", description="Managing sites")
public class SiteManagementRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SiteManagementRestService.class);
    private Portal portal;

    public SiteManagementRestService(Portal portal) {
        this.portal = portal;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Retrieve sites", method="GET", description="This retrieves sites")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSites() {
        try {
            Filter<Site> filter = new Filter<Site>(){

                public boolean accept(Site site) {
                    return !site.getName().startsWith("/spaces/");
                }
            };
            SiteQuery pageQuery = new SiteQuery.Builder().withSiteTypes(SiteType.SITE, new SiteType[]{SiteType.SPACE}).withFilter((Filter)filter).build();
            List sites = this.portal.findSites(pageQuery);
            List<SiteRestEntity> siteRestEntities = EntityBuilder.toSiteRestEntities(sites).stream().sorted(Comparator.comparing(SiteRestEntity::getDisplayName, String.CASE_INSENSITIVE_ORDER)).toList();
            return Response.ok().entity(siteRestEntities).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when retrieving sites", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Delete a site", method="GET", description="This deletes the given site")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteSite(@Parameter(description="site type") @QueryParam(value="siteType") String siteType, @Parameter(description="site name") @QueryParam(value="siteName") String siteName) {
        try {
            SiteId siteId = Util.from((SiteKey)new SiteKey(siteType, siteName));
            this.portal.removeSite(siteId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Error when deleting the site with name {} and type {}", new Object[]{siteName, siteType, e});
            return Response.serverError().build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="update a site", method="PUT", description="This updates the given site")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateSite(@Parameter(description="site type") @QueryParam(value="siteType") String siteType, @Parameter(description="site name") @QueryParam(value="siteName") String siteName, @Parameter(description="site Label") @QueryParam(value="siteLabel") String siteLabel, @Parameter(description="site description") @QueryParam(value="siteDescription") String siteDescription) {
        try {
            SiteId siteId = Util.from((SiteKey)new SiteKey(siteType, siteName));
            Site site = this.portal.getSite(siteId);
            site.setDescription(siteDescription);
            site.setDisplayName(siteLabel);
            this.portal.saveSite(site);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Error when updating the site with name {} and type {}", new Object[]{siteName, siteType, e});
            return Response.serverError().build();
        }
    }

    @Path(value="/permissions")
    @PATCH
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Update a page access and edit permission", method="PATCH", description="This updates the given page access and edit permission")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page permissions updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Page not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateSitePermissions(@Parameter(description="Site type", required=true) @QueryParam(value="siteType") String siteType, @Parameter(description="Site name", required=true) @QueryParam(value="siteName") String siteName, @Parameter(description="Site new edit permission", required=true) @QueryParam(value="editPermission") String editPermission, @Parameter(description="Site new access permissions", required=true) @QueryParam(value="accessPermissions") String accessPermissions) {
        try {
            if (StringUtils.isBlank((String)siteName) || StringUtils.isBlank((String)siteType)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"params are mandatory").build();
            }
            SiteId siteId = Util.from((SiteKey)new SiteKey(siteType, siteName));
            Site site = this.portal.getSite(siteId);
            if (site == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!SiteManagementUtils.canEditSite(site)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (!StringUtils.isBlank((String)editPermission)) {
                site.setEditPermission(Util.from((String[])new String[]{editPermission}));
            }
            if (!StringUtils.isBlank((String)accessPermissions)) {
                List accessPermissionsList = List.of(accessPermissions.split(",")).stream().distinct().toList();
                site.setAccessPermission(Util.from(accessPermissionsList));
            }
            this.portal.saveSite(site);
            return Response.ok((Object)EntityBuilder.toSiteRestEntity(this.portal.getSite(siteId))).build();
        }
        catch (Exception e) {
            LOG.error("Error when updating site permissions with name {} and type {}", new Object[]{siteName, siteType, e});
            return Response.serverError().build();
        }
    }
}

