/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.navigation.webui.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.navigation.webui.component.UINavigationManagement;
import org.exoplatform.navigation.webui.component.UIPageNodeForm;
import org.exoplatform.navigation.webui.component.UISiteManagement;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.util.ReflectionUtil;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormTabPane;

@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/navigation/webui/component/UISiteManagement.gtmpl", events={@EventConfig(name="EditPortalLayout", listeners={EditPortalLayoutActionListener.class}), @EventConfig(listeners={EditNavigationActionListener.class}), @EventConfig(listeners={DeletePortalActionListener.class}, confirm="UIPortalBrowser.deletePortal")}), @ComponentConfig(type=UIPageNodeForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={UIPageNodeForm.SaveActionListener.class}), @EventConfig(listeners={UIPageNodeForm.ChangeLanguageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchLabelModeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchPublicationDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchVisibleActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.ClearPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.CreatePageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormTabPane.SelectTabActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, name="ClosePopup")})})
public class UISiteManagement
extends UIContainer {
    public static String[] ACTIONS = new String[]{"EditNavigation", "DeletePortal", "EditPortalLayout"};
    private LazyPageList<PortalConfig> pageList;
    private UINavigationManagement naviManager;
    private Scope navigationScope = Scope.GRANDCHILDREN;

    public UISiteManagement() throws Exception {
        UIPopupWindow editNavigation = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, null);
        editNavigation.setWindowSize(400, 400);
        editNavigation.setId(editNavigation.getId() + "-" + UUID.randomUUID().toString().replaceAll("-", ""));
    }

    public List<PortalConfig> getPortalConfigs() throws Exception {
        return this.pageList.getAll();
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public Object getFieldValue(Object bean, String field) throws Exception {
        Method method = ReflectionUtil.getGetBindingMethod((Object)bean, (String)field);
        return method.invoke(bean, ReflectionUtil.EMPTY_ARGS);
    }

    public void loadPortalConfigs() throws Exception {
        DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        LazyPageList temp = service.find(query, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList tempArrayList = new ArrayList();
        if (temp != null) {
            tempArrayList.addAll(temp.getAll());
        }
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        Iterator iterPortals = tempArrayList.iterator();
        while (iterPortals.hasNext()) {
            PortalConfig portalConfig = (PortalConfig)iterPortals.next();
            if (userACL.hasEditPermission(portalConfig)) continue;
            iterPortals.remove();
        }
        this.pageList = new LazyPageList((ListAccess)new /* Unavailable Anonymous Inner Class!! */, 10);
    }

    public void setScope(Scope scope) {
        this.navigationScope = scope;
    }

    public Scope getScope() {
        return this.navigationScope;
    }

    private boolean stillKeptInPageList(String portalName) throws Exception {
        List portals = this.getPortalConfigs();
        for (PortalConfig p : portals) {
            if (!p.getName().equals(portalName)) continue;
            return true;
        }
        return false;
    }
}

