/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.leadcapture.dto.MailTemplateDTO;
import org.exoplatform.leadcapture.entity.MailTemplateEntity;
import org.exoplatform.leadcapture.services.MailTemplatesManagementService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;

@Path(value="/leadcapture/mailtemplatesmanagement")
@Produces(value={"application/json"})
public class MailTemplatesManagementRest
implements ResourceContainer {
    private final Log LOG = ExoLogger.getLogger(MailTemplatesManagementRest.class);
    private final String portalContainerName = "portal";
    private MailTemplatesManagementService mailTemplatesManagementService;

    public MailTemplatesManagementRest(MailTemplatesManagementService mailTemplatesManagementService) {
        this.mailTemplatesManagementService = mailTemplatesManagementService;
    }

    @GET
    @Path(value="templates")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getTemplates(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok(this.mailTemplatesManagementService.getTemplates()).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get templates list", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="templates")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response add(@Context UriInfo uriInfo, MailTemplateDTO templateDTO) throws Exception {
        try {
            this.mailTemplatesManagementService.addTemplate(templateDTO);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Mail template created").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to add new template {}", new Object[]{templateDTO.getName(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="templates/{id}")
    @RolesAllowed(value={"ux-team"})
    public Response delete(@Context UriInfo uriInfo, @PathParam(value="id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            MailTemplateEntity templateEntity = this.mailTemplatesManagementService.getTemplatebyId(id);
            if (templateEntity == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Lead Not found").build();
            }
            this.mailTemplatesManagementService.deleteTemplate(templateEntity);
            this.LOG.info("Template {} deleted by {}", new Object[]{id, sourceIdentity.getRemoteId()});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Mail template deleted").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to delete template {}", new Object[]{id, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="templates")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response update(@Context UriInfo uriInfo, MailTemplateDTO templateDTO) throws Exception {
        try {
            this.mailTemplatesManagementService.updateTemplate(templateDTO);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Mail template updated").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to update template {}", new Object[]{templateDTO.getId(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

