/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.jobs;

import java.util.Date;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.leadcapture.Utils;
import org.exoplatform.leadcapture.dto.CompaignDTO;
import org.exoplatform.leadcapture.dto.MailContentDTO;
import org.exoplatform.leadcapture.dto.MailTemplateDTO;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.services.CompaignManagementService;
import org.exoplatform.leadcapture.services.LCMailService;
import org.exoplatform.leadcapture.services.LeadsManagementService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.TaskService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CompaignsJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(CompaignsJob.class);
    private CompaignManagementService compaignManagementService = (CompaignManagementService)CommonsUtils.getService(CompaignManagementService.class);
    private LeadsManagementService leadsManagementService = (LeadsManagementService)CommonsUtils.getService(LeadsManagementService.class);
    private TaskService taskService = (TaskService)CommonsUtils.getService(TaskService.class);
    private LCMailService lcMailService = (LCMailService)CommonsUtils.getService(LCMailService.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        LOG.info((Object)"Compaigns Job started");
        List<CompaignDTO> compaignDTOList = this.compaignManagementService.getCompaigns();
        for (CompaignDTO compaignDTO : compaignDTOList) {
            if (!compaignDTO.getField().equals("status")) continue;
            List<LeadEntity> leadsEntities = this.leadsManagementService.getLeadsByStatus(compaignDTO.getValue());
            for (LeadEntity leadEntity : leadsEntities) {
                if (leadEntity == null || leadEntity.getTaskId() == null || leadEntity.getTaskId() == 0L) continue;
                try {
                    Task task = this.taskService.getTask(leadEntity.getTaskId().longValue());
                    ListAccess logs = this.taskService.getTaskLogs(leadEntity.getTaskId().longValue());
                    for (ChangeLog log : (ChangeLog[])logs.load(0, logs.getSize())) {
                        if (!log.getActionName().equals("edit_status") || !log.getTarget().equals(compaignDTO.getValue()) || Utils.calculateNumberOfDays(new Date().getTime(), log.getCreatedTime()) + 1.0f != (float)compaignDTO.getAfter()) continue;
                        MailContentDTO content = null;
                        MailTemplateDTO mailTemplateDTO = compaignDTO.getMailTemplateDTO();
                        if (mailTemplateDTO.getContents().size() <= 0 || (content = Utils.getContentForMail(mailTemplateDTO, leadEntity)) == null) continue;
                        this.lcMailService.sendMail(content.getContent(), content.getSubject(), leadEntity, null, null);
                        LOG.info("service=lead-capture operation=send_mail_to_lead parameters=\"lead_id:{},lead_name:{},mail_template_id:{},mail_template_name:{},reason: compaign\"", new Object[]{leadEntity.getId(), leadEntity.getFirstName() + " " + leadEntity.getLastName(), mailTemplateDTO.getId(), mailTemplateDTO.getName()});
                    }
                }
                catch (Exception e) {
                    LOG.error("Cannot get Task log for lead {}", new Object[]{leadEntity.getId(), e});
                }
            }
        }
        LOG.info((Object)"Compaigns Job started");
    }
}

