/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.test.service;

import java.util.List;
import org.exoplatform.leadcapture.dto.FieldDTO;
import org.exoplatform.leadcapture.dto.FormDTO;
import org.exoplatform.leadcapture.dto.FormInfo;
import org.exoplatform.leadcapture.dto.LeadDTO;
import org.exoplatform.leadcapture.dto.ResponseDTO;
import org.exoplatform.leadcapture.entity.FieldEntity;
import org.exoplatform.leadcapture.entity.FormEntity;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.entity.ResponseEntity;
import org.exoplatform.leadcapture.services.LeadsManagementService;
import org.exoplatform.leadcapture.test.BaseLeadManagementTest;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;

public class LeadsManagementTest
extends BaseLeadManagementTest {
    @Test
    public void testServiceInstantiated() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        Assert.assertNotNull((Object)leadsManagementService);
    }

    @Test
    public void addLeadInfo() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        FormInfo formInfo = new FormInfo();
        formInfo.setLead(this.newLeadDto());
        formInfo.setResponse(this.newResponseDTO());
        List leads = leadsManagementService.getLeads();
        Assert.assertNotNull((Object)leads);
        Assert.assertEquals((long)0L, (long)leads.size());
        try {
            leadsManagementService.addLeadInfo(formInfo, false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        leads = leadsManagementService.getLeads();
        Assert.assertNotNull((Object)leads);
        Assert.assertEquals((long)1L, (long)leads.size());
        Assert.assertEquals((long)1L, (long)leadsManagementService.getResponses(((LeadDTO)leads.get(0)).getId().longValue()).length());
    }

    @Test
    public void deleteLead() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        Assert.assertNotNull((Object)leadsManagementService.getLeadbyId(leadEntity.getId().longValue()));
        try {
            leadsManagementService.deleteLead(leadEntity);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals(null, (Object)leadsManagementService.getLeadbyId(leadEntity.getId().longValue()));
    }

    @Test
    public void updateLead() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        Assert.assertEquals((Object)this.language, (Object)leadEntity.getLanguage());
        leadEntity.setLanguage("fr");
        try {
            leadsManagementService.updateLead(leadsManagementService.toLeadDto(leadEntity));
        }
        catch (Exception e) {
            Assert.fail();
        }
        leadEntity = leadsManagementService.getLeadbyId(leadEntity.getId().longValue());
        Assert.assertEquals((Object)"fr", (Object)leadEntity.getLanguage());
    }

    @Test
    public void updateForm() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        FormEntity formEntity = this.newForm();
        Assert.assertEquals((Object)this.formName, (Object)formEntity.getName());
        formEntity.setName("new name");
        formEntity = leadsManagementService.updateForm(formEntity);
        Assert.assertEquals((Object)"new name", (Object)formEntity.getName());
    }

    @Test
    public void assigneLead() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        Assert.assertEquals((Object)this.assignee, (Object)leadEntity.getAssignee());
        try {
            leadsManagementService.assigneLead(leadEntity.getId(), "testUser");
        }
        catch (Exception e) {
            Assert.fail();
        }
        leadEntity = leadsManagementService.getLeadbyId(leadEntity.getId().longValue());
        Assert.assertEquals((Object)"testUser", (Object)leadEntity.getAssignee());
    }

    @Test
    public void updateStatus() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        Assert.assertEquals((Object)this.status, (Object)leadEntity.getStatus());
        try {
            leadsManagementService.updateStatus(leadEntity.getId(), "Raw", "test");
        }
        catch (Exception e) {
            Assert.fail();
        }
        leadEntity = leadsManagementService.getLeadbyId(leadEntity.getId().longValue());
        Assert.assertEquals((Object)"Raw", (Object)leadEntity.getStatus());
    }

    @Test
    public void getLeads() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        Assert.assertEquals((long)0L, (long)leadsManagementService.getLeads().size());
        this.newLead();
        Assert.assertEquals((long)1L, (long)leadsManagementService.getLeads().size());
    }

    @Test
    public void getResponses() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        Assert.assertEquals((long)0L, (long)leadsManagementService.getResponses(leadEntity.getId().longValue()).length());
        this.newResponse(this.newForm(), leadEntity);
        Assert.assertEquals((long)1L, (long)leadsManagementService.getResponses(leadEntity.getId().longValue()).length());
    }

    @Test
    public void addResponse() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        Assert.assertEquals((long)0L, (long)leadsManagementService.getResponses(leadEntity.getId().longValue()).length());
        try {
            leadsManagementService.addResponse(this.newResponseDTO(), leadEntity);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)1L, (long)leadsManagementService.getResponses(leadEntity.getId().longValue()).length());
    }

    @Test
    public void getLeadbyId() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        Assert.assertNotNull((Object)leadsManagementService.getLeadbyId(leadEntity.getId().longValue()));
    }

    @Test
    public void getLeadByMail() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        Assert.assertNotNull((Object)leadsManagementService.getLeadByMail(this.mail));
    }

    @Test
    public void mergeLead() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        Assert.assertNotNull((Object)leadsManagementService.mergeLead(this.newLead(), this.newLeadDto()));
    }

    @Test
    public void toFormJson() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        try {
            Assert.assertNotNull((Object)leadsManagementService.toFormJson(this.newForm()));
        }
        catch (JSONException e) {
            Assert.fail();
        }
    }

    @Test
    public void toLeadDto() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadEntity leadEntity = this.newLead();
        LeadDTO leadDTO = leadsManagementService.toLeadDto(leadEntity);
        this.compareLeadResult(leadEntity, leadDTO);
    }

    @Test
    public void toLeadEntity() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        LeadDTO leadDTO = this.newLeadDto();
        LeadEntity leadEntity = leadsManagementService.toLeadEntity(leadDTO);
        this.compareLeadResult(leadEntity, leadDTO);
    }

    @Test
    public void toFieldDto() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        ResponseEntity responseEntity = this.newResponse(this.newForm(), this.newLead());
        FieldEntity fieldEntity = this.newField(responseEntity);
        FieldDTO fieldDTO = leadsManagementService.toFieldDto(fieldEntity);
        this.compareFieldResult(fieldEntity, fieldDTO);
    }

    @Test
    public void toFieldEntity() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        FieldDTO fieldDTO = this.newFieldDTO();
        FieldEntity fieldEntity = leadsManagementService.toFieldEntity(fieldDTO);
        this.compareFieldResult(fieldEntity, fieldDTO);
    }

    @Test
    public void toFormDto() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        FormEntity formEntity = this.newForm();
        FormDTO formDTO = leadsManagementService.toFormDto(formEntity);
        this.compareFormResult(formEntity, formDTO);
    }

    @Test
    public void toFormEntity() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        FormDTO formDTO = this.newFormDto();
        FormEntity formEntity = leadsManagementService.toFormEntity(formDTO);
        this.compareFormResult(formEntity, formDTO);
    }

    @Test
    public void toResponseDto() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        ResponseEntity responseEntity = this.newResponse(this.newForm(), this.newLead());
        ResponseDTO responseDTO = leadsManagementService.toResponseDto(responseEntity);
        this.compareResponseResult(responseEntity, responseDTO);
    }

    @Test
    public void toResponseEntity() {
        LeadsManagementService leadsManagementService = this.getService(LeadsManagementService.class);
        ResponseDTO responseDTO = this.newResponseDTO();
        ResponseEntity responseEntity = leadsManagementService.toResponseEntity(responseDTO);
        this.compareResponseResult(responseEntity, responseDTO);
    }
}

