/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.test;

import java.util.ArrayList;
import java.util.Date;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.leadcapture.dao.FieldDAO;
import org.exoplatform.leadcapture.dao.FormDAO;
import org.exoplatform.leadcapture.dao.LeadDAO;
import org.exoplatform.leadcapture.dao.ResponseDAO;
import org.exoplatform.leadcapture.dto.FieldDTO;
import org.exoplatform.leadcapture.dto.FormDTO;
import org.exoplatform.leadcapture.dto.LeadDTO;
import org.exoplatform.leadcapture.dto.ResponseDTO;
import org.exoplatform.leadcapture.entity.FieldEntity;
import org.exoplatform.leadcapture.entity.FormEntity;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.entity.ResponseEntity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class BaseLeadManagementTest {
    protected static PortalContainer container;
    protected String mail = "test@exoplatform.com";
    protected String firstName = "User";
    protected String lastName = "Test";
    protected String company = "eXo";
    protected String position = "Manager";
    protected String inferredCountry = "Tunisia";
    protected String status = "opened";
    protected String language = "en";
    protected String assignee = "root";
    protected String phone = "2222222222";
    protected String geographiqueZone = "geographiqueZone";
    protected boolean marketingSuspended = false;
    protected String marketingSuspendedCause = "";
    protected String captureMethod = "captureMethod";
    protected String captureType = "captureType";
    protected boolean blogSubscription = true;
    protected String communityUserName = "communityUserName";
    protected boolean communityRegistration = true;
    protected String communityRegistrationMethod = "communityRegistrationMethod";
    protected String personSource = "personSource";
    protected String landingPageInfo = "landingPageInfo";
    protected String captureSourceInfo = "captureSourceInfo";
    protected String personIp = "personIp";
    protected String originalReferrer = "originalReferrer";
    protected String formName = "newForm";
    protected String formFields = "name,message,createdDate";
    protected String fieldName = "fieldName";
    protected String fieldValue = "fieldValue";

    @BeforeClass
    public static void beforeTest() {
        container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)container);
    }

    @Before
    public void beforeMethodTest() {
        RequestLifeCycle.begin((ExoContainer)container);
    }

    @After
    public void afterMethodTest() {
        LeadDAO leadDAO = this.getService(LeadDAO.class);
        FormDAO formDAO = this.getService(FormDAO.class);
        ResponseDAO responseDAO = this.getService(ResponseDAO.class);
        FieldDAO fieldDAO = this.getService(FieldDAO.class);
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)container);
        fieldDAO.deleteAll();
        responseDAO.deleteAll();
        leadDAO.deleteAll();
        formDAO.deleteAll();
        RequestLifeCycle.end();
    }

    protected <T> T getService(Class<T> componentType) {
        return (T)container.getComponentInstanceOfType(componentType);
    }

    protected LeadEntity newLead() {
        LeadDAO leadDAO = this.getService(LeadDAO.class);
        LeadEntity leadEntity = new LeadEntity();
        leadEntity.setMail(this.mail);
        leadEntity.setFirstName(this.firstName);
        leadEntity.setLastName(this.lastName);
        leadEntity.setCompany(this.company);
        leadEntity.setPosition(this.position);
        leadEntity.setCountry(this.inferredCountry);
        leadEntity.setStatus(this.status);
        leadEntity.setLanguage(this.language);
        leadEntity.setAssignee(this.assignee);
        leadEntity.setPhone(this.phone);
        leadEntity.setCreatedDate(new Date());
        leadEntity.setUpdatedDate(new Date());
        leadEntity.setGeographiqueZone(this.geographiqueZone);
        leadEntity.setMarketingSuspended(Boolean.valueOf(this.marketingSuspended));
        leadEntity.setMarketingSuspendedCause(this.marketingSuspendedCause);
        leadEntity.setCaptureMethod(this.captureMethod);
        leadEntity.setCaptureType(this.captureType);
        leadEntity.setBlogSubscription(Boolean.valueOf(this.blogSubscription));
        leadEntity.setBlogSubscriptionDate(new Date());
        leadEntity.setCommunityUserName(this.communityUserName);
        leadEntity.setCommunityRegistration(Boolean.valueOf(this.communityRegistration));
        leadEntity.setCommunityRegistrationMethod(this.communityRegistrationMethod);
        leadEntity.setCommunityRegistrationDate(new Date());
        leadEntity.setPersonSource(this.personSource);
        leadEntity.setLandingPageInfo(this.landingPageInfo);
        leadEntity.setCaptureSourceInfo(this.captureSourceInfo);
        leadEntity.setPersonIp(this.personIp);
        leadEntity.setOriginalReferrer(this.originalReferrer);
        leadEntity = (LeadEntity)leadDAO.create((Object)leadEntity);
        return leadEntity;
    }

    protected LeadDTO newLeadDto() {
        LeadDTO leadDTO = new LeadDTO();
        leadDTO.setMail(this.mail);
        leadDTO.setFirstName(this.firstName);
        leadDTO.setLastName(this.lastName);
        leadDTO.setCompany(this.company);
        leadDTO.setPosition(this.position);
        leadDTO.setInferredCountry(this.inferredCountry);
        leadDTO.setStatus(this.status);
        leadDTO.setLanguage(this.language);
        leadDTO.setAssignee(this.assignee);
        leadDTO.setPhone(this.phone);
        leadDTO.setGeographiqueZone(this.geographiqueZone);
        leadDTO.setMarketingSuspended(Boolean.valueOf(this.marketingSuspended));
        leadDTO.setMarketingSuspendedCause(this.marketingSuspendedCause);
        leadDTO.setCaptureMethod(this.captureMethod);
        leadDTO.setCaptureType(this.captureType);
        leadDTO.setBlogSubscription(Boolean.valueOf(this.blogSubscription));
        leadDTO.setBlogSubscriptionDate(new Date());
        leadDTO.setCommunityUserName(this.communityUserName);
        leadDTO.setCommunityRegistration(Boolean.valueOf(this.communityRegistration));
        leadDTO.setCommunityRegistrationMethod(this.communityRegistrationMethod);
        leadDTO.setCommunityRegistrationDate(new Date());
        leadDTO.setPersonSource(this.personSource);
        leadDTO.setLandingPageInfo(this.landingPageInfo);
        leadDTO.setCaptureSourceInfo(this.captureSourceInfo);
        leadDTO.setPersonIp(this.personIp);
        leadDTO.setOriginalReferrer(this.originalReferrer);
        return leadDTO;
    }

    protected FormEntity newForm() {
        FormDAO formDAO = this.getService(FormDAO.class);
        FormEntity formEntity = new FormEntity();
        formEntity.setName(this.formName);
        formEntity.setFields(this.formFields);
        formEntity = (FormEntity)formDAO.create((Object)formEntity);
        return formEntity;
    }

    protected FormDTO newFormDto() {
        FormDTO formDTO = new FormDTO();
        formDTO.setName(this.formName);
        formDTO.setFields(this.formFields);
        return formDTO;
    }

    protected ResponseEntity newResponse(FormEntity formEntity, LeadEntity leadEntity) {
        ResponseDAO responseDAO = this.getService(ResponseDAO.class);
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setFormEntity(formEntity);
        responseEntity.setLeadEntity(leadEntity);
        responseEntity.setCreatedDate(new Date());
        responseEntity = (ResponseEntity)responseDAO.create((Object)responseEntity);
        return responseEntity;
    }

    protected ResponseDTO newResponseDTO() {
        ResponseDTO responseDTO = new ResponseDTO();
        responseDTO.setForm(this.newFormDto());
        responseDTO.setFormName(responseDTO.getForm().getName());
        ArrayList<FieldDTO> fields = new ArrayList<FieldDTO>();
        fields.add(this.newFieldDTO());
        responseDTO.setFields(fields);
        return responseDTO;
    }

    protected FieldEntity newField(ResponseEntity responseEntity) {
        FieldDAO fieldDAO = this.getService(FieldDAO.class);
        FieldEntity fieldEntity = new FieldEntity();
        fieldEntity.setName(this.fieldName);
        fieldEntity.setValue(this.fieldValue);
        fieldEntity.setResponseEntity(responseEntity);
        fieldEntity = (FieldEntity)fieldDAO.create((Object)fieldEntity);
        return fieldEntity;
    }

    protected FieldDTO newFieldDTO() {
        FieldDTO fieldDTO = new FieldDTO();
        fieldDTO.setName(this.fieldName);
        fieldDTO.setValue(this.fieldValue);
        return fieldDTO;
    }

    protected void compareLeadResult(LeadEntity leadEntity, LeadDTO leadDTO) {
        Assert.assertEquals((Object)leadEntity.getId(), (Object)leadDTO.getId());
        Assert.assertEquals((Object)leadEntity.getMail(), (Object)leadDTO.getMail());
        Assert.assertEquals((Object)leadEntity.getFirstName(), (Object)leadDTO.getFirstName());
        Assert.assertEquals((Object)leadEntity.getLastName(), (Object)leadDTO.getLastName());
        Assert.assertEquals((Object)leadEntity.getCompany(), (Object)leadDTO.getCompany());
        Assert.assertEquals((Object)leadEntity.getPosition(), (Object)leadDTO.getPosition());
        Assert.assertEquals((Object)leadEntity.getCountry(), (Object)leadDTO.getInferredCountry());
        Assert.assertEquals((Object)leadEntity.getStatus(), (Object)leadDTO.getStatus());
        Assert.assertEquals((Object)leadEntity.getPhone(), (Object)leadDTO.getPhone());
        Assert.assertEquals((Object)leadEntity.getCreatedDate(), (Object)leadDTO.getCreatedDate());
        Assert.assertEquals((Object)leadEntity.getUpdatedDate(), (Object)leadDTO.getUpdatedDate());
        Assert.assertEquals((Object)leadEntity.getLanguage(), (Object)leadDTO.getLanguage());
        Assert.assertEquals((Object)leadEntity.getAssignee(), (Object)leadDTO.getAssignee());
        Assert.assertEquals((Object)leadEntity.getGeographiqueZone(), (Object)leadDTO.getGeographiqueZone());
        Assert.assertEquals((Object)leadEntity.getMarketingSuspended(), (Object)leadDTO.getMarketingSuspended());
        Assert.assertEquals((Object)leadEntity.getMarketingSuspendedCause(), (Object)leadDTO.getMarketingSuspendedCause());
        Assert.assertEquals((Object)leadEntity.getCaptureMethod(), (Object)leadDTO.getCaptureMethod());
        Assert.assertEquals((Object)leadEntity.getCaptureType(), (Object)leadDTO.getCaptureType());
        Assert.assertEquals((Object)leadEntity.getBlogSubscription(), (Object)leadDTO.getBlogSubscription());
        Assert.assertEquals((Object)leadEntity.getBlogSubscriptionDate(), (Object)leadDTO.getBlogSubscriptionDate());
        Assert.assertEquals((Object)leadEntity.getCommunityUserName(), (Object)leadDTO.getCommunityUserName());
        Assert.assertEquals((Object)leadEntity.getCommunityRegistration(), (Object)leadDTO.getCommunityRegistration());
        Assert.assertEquals((Object)leadEntity.getCommunityRegistrationMethod(), (Object)leadDTO.getCommunityRegistrationMethod());
        Assert.assertEquals((Object)leadEntity.getCommunityRegistrationDate(), (Object)leadDTO.getCommunityRegistrationDate());
        Assert.assertEquals((Object)leadEntity.getPersonSource(), (Object)leadDTO.getPersonSource());
        Assert.assertEquals((Object)leadEntity.getLandingPageInfo(), (Object)leadDTO.getLandingPageInfo());
        Assert.assertEquals((Object)leadEntity.getCaptureSourceInfo(), (Object)leadDTO.getCaptureSourceInfo());
        Assert.assertEquals((Object)leadEntity.getPersonIp(), (Object)leadDTO.getPersonIp());
        Assert.assertEquals((Object)leadEntity.getOriginalReferrer(), (Object)leadDTO.getOriginalReferrer());
    }

    protected void compareFormResult(FormEntity formEntity, FormDTO formDTO) {
        Assert.assertEquals((Object)formEntity.getId(), (Object)formDTO.getId());
        Assert.assertEquals((Object)formEntity.getName(), (Object)formDTO.getName());
        Assert.assertEquals((Object)formEntity.getFields(), (Object)formDTO.getFields());
    }

    protected void compareResponseResult(ResponseEntity responseEntity, ResponseDTO responseDTO) {
        Assert.assertEquals((Object)responseEntity.getId(), (Object)responseDTO.getId());
        this.compareFormResult(responseEntity.getFormEntity(), responseDTO.getForm());
    }

    protected void compareFieldResult(FieldEntity fieldEntity, FieldDTO fieldDTO) {
        Assert.assertEquals((Object)fieldEntity.getId(), (Object)fieldDTO.getId());
        Assert.assertEquals((Object)fieldEntity.getName(), (Object)fieldDTO.getName());
        Assert.assertEquals((Object)fieldEntity.getValue(), (Object)fieldDTO.getValue());
    }
}

