/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.leadcapture.dto.LeadCaptureSettings;
import org.exoplatform.leadcapture.services.LeadCaptureSettingsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.json.JSONObject;

@Path(value="/leadcapture/lcsettings")
@Produces(value={"application/json"})
public class LeadCaptureSettingsRest
implements ResourceContainer {
    private final Log LOG = ExoLogger.getLogger(LeadCaptureSettingsRest.class);
    private final String portalContainerName = "portal";
    private final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private LeadCaptureSettingsService leadCaptureSettingsService;

    public LeadCaptureSettingsRest(LeadCaptureSettingsService leadCaptureSettingsService) {
        this.leadCaptureSettingsService = leadCaptureSettingsService;
    }

    @GET
    @Path(value="settings")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getSettings(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadCaptureSettingsService.getSettings()).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get capture settings", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="settings")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response save(@Context UriInfo uriInfo, LeadCaptureSettings settings) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.leadCaptureSettingsService.saveSettings(settings);
            this.LOG.info("Lead capture settings updated by {}", new Object[]{sourceIdentity.getRemoteId()});
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"Settings updated").build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to set capture settings", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="context")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getContext(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
            JSONObject context = new JSONObject();
            context.put("currentUser", (Object)sourceIdentity.getRemoteId());
            context.put("currentUserFullName", (Object)sourceIdentity.getProfile().getFullName());
            context.put("isManager", this.isManager(sourceIdentity.getRemoteId(), settings.getUserExperienceGroup()));
            context.put("leadCaptureConfigured", this.isConfigured(settings));
            return Response.ok((Object)context.toString()).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get capture context", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    public boolean isManager(String userName, String group) {
        try {
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            if (group != null && organizationService.getMembershipHandler().findMembershipByUserGroupAndType(userName, group, "manager") != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying check if user is a manager of the group {}", new Object[]{group, e});
            return false;
        }
        return false;
    }

    public boolean isConfigured(LeadCaptureSettings settings) {
        return StringUtils.isNotEmpty((CharSequence)settings.getUserExperienceGroup()) && StringUtils.isNotEmpty((CharSequence)settings.getUserExperienceGroup()) && StringUtils.isNotEmpty((CharSequence)settings.getUserExperienceSpace()) && StringUtils.isNotEmpty((CharSequence)settings.getSenderMail());
    }
}

