/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This file is part of Lecko Analytics Add-on - Service.
 *
 * Lecko Analytics Add-on - Service is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 3 of
 * the License, or (at your option) any later version.
 *
 * Lecko Analytics Add-on - Service software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Lecko Analytics Add-on - Service; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.addons.lecko.social.rest.api;

import org.exoplatform.services.security.ConversationState;

public class Utils {
	
	 public static final String API_ACCESS_GROUP    = "/platform/api-access";
	 
	  /**
	   * Check if the authenticated user is a member of the api access group
	   * 
	   * @return boolean
	   */
	  public static boolean isMemberOfAPIAccessGroup() {
	    return ConversationState.getCurrent().getIdentity().isMemberOf(API_ACCESS_GROUP);
	  }

}
