/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.toolbar.portlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.platform.common.service.MenuConfiguratorService;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.NavigationURLUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.gatein.common.text.EntityEncoder;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="war:/groovy/platformNavigation/portlet/UISetupPlatformToolBarPortlet/UISetupPlatformToolBarPortlet.gtmpl")
public class UISetupPlatformToolBarPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UISetupPlatformToolBarPortlet.class);
    private static Map<Locale, Map<String, String>> resolvedEncodeLabels = Collections.synchronizedMap(new HashMap());
    private MenuConfiguratorService menuConfiguratorService;
    private UserPortalConfigService portalConfigService;
    private List<UserNode> setupMenuUserNodes = null;
    private List<PageNode> setupMenuPageNodes = null;
    private Map<String, Boolean> pagePermissionsMap = new HashMap();
    private UserNodeFilterConfig NAVIGATION_FILTER_CONFIG;
    private static final String NOTIFICATION_NODE_NAME = "notification";

    public UISetupPlatformToolBarPortlet() throws Exception {
        UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
        this.menuConfiguratorService = (MenuConfiguratorService)this.getApplicationComponent(MenuConfiguratorService.class);
        this.portalConfigService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        this.setupMenuUserNodes = this.menuConfiguratorService.getSetupMenuItems(UISetupPlatformToolBarPortlet.getUserPortal());
        this.pagePermissionsMap.clear();
        this.NAVIGATION_FILTER_CONFIG = filterConfigBuilder.build();
    }

    public static UserPortal getUserPortal() {
        UserPortalConfig portalConfig = Util.getPortalRequestContext().getUserPortalConfig();
        return portalConfig.getUserPortal();
    }

    public boolean hasPermissionOnPageNode(PageNode pageNode) throws Exception {
        PageContext pageContext;
        Boolean hasPermission = null;
        if (pageNode.getPageReference() != null && (hasPermission = (Boolean)this.pagePermissionsMap.get(pageNode.getPageReference())) == null && (pageContext = this.portalConfigService.getPage(PageKey.parse((String)pageNode.getPageReference()))) != null) {
            hasPermission = true;
        }
        if (hasPermission == null && pageNode.getChildren() != null && !pageNode.getChildren().isEmpty()) {
            for (PageNode childPageNode : pageNode.getChildren()) {
                if (!this.hasPermissionOnPageNode(childPageNode)) continue;
                hasPermission = true;
            }
        }
        if (hasPermission == null) {
            hasPermission = false;
        }
        this.pagePermissionsMap.put(pageNode.getPageReference(), hasPermission);
        return hasPermission;
    }

    public String getHREF(PageNode pageNode) {
        String pageReference = pageNode.getPageReference();
        UserNode userNode = this.getOriginalUserNode(pageReference);
        if (userNode == null) {
            UserNavigation userNavigation = UISetupPlatformToolBarPortlet.getUserPortal().getNavigation(new SiteKey(this.getOwnerType(pageReference), this.getOwnerName(pageReference)));
            userNode = this.searchUserNodeByPageReference(UISetupPlatformToolBarPortlet.getUserPortal(), userNavigation, pageReference);
        }
        if (userNode == null) {
            return null;
        }
        return NavigationURLUtils.getURL((UserNode)userNode);
    }

    private String getOwnerType(String pageReference) {
        String[] pageIds = pageReference.split("::");
        return pageIds[0];
    }

    private String getOwnerName(String pageReference) {
        String[] pageIds = pageReference.split("::");
        return pageIds[1];
    }

    private UserNode searchUserNodeByPageReference(Collection<UserNode> userNodes, String pageReference) {
        if (userNodes == null || userNodes.isEmpty()) {
            return null;
        }
        for (UserNode userNode : userNodes) {
            UserNode childNode;
            if (userNode.getPageRef() != null && userNode.getPageRef().format().equals(pageReference)) {
                return userNode;
            }
            if (userNode.getChildren() == null || userNode.getChildren().isEmpty() || (childNode = this.searchUserNodeByPageReference(userNode.getChildren(), pageReference)) == null) continue;
            return childNode;
        }
        return null;
    }

    private UserNode searchUserNodeByPageReference(UserPortal userPortal, UserNavigation nav, String pageReference) {
        if (nav != null) {
            try {
                UserNode rootNode = userPortal.getNode(nav, Scope.ALL, this.NAVIGATION_FILTER_CONFIG, null);
                if (rootNode.getPageRef() != null && pageReference.equals(rootNode.getPageRef())) {
                    return rootNode;
                }
                if (rootNode.getChildren() != null && !rootNode.getChildren().isEmpty()) {
                    return this.searchUserNodeByPageReference(rootNode.getChildren(), pageReference);
                }
            }
            catch (Exception exp) {
                LOG.warn((Object)(nav.getKey().getName() + " has been deleted"));
            }
        }
        return null;
    }

    public String getEncodedResolvedLabel(PageNode pageNode) {
        if (pageNode.getLabel() != null && !pageNode.getLabel().isEmpty()) {
            String resolvedLabel;
            Locale locale = Util.getPortalRequestContext().getLocale();
            Map<String, String> i18nizedLabels = (Map<String, String>)resolvedEncodeLabels.get(locale);
            if (i18nizedLabels == null) {
                i18nizedLabels = Collections.synchronizedMap(new HashMap());
                resolvedEncodeLabels.put(locale, i18nizedLabels);
            }
            if ((resolvedLabel = (String)i18nizedLabels.get(pageNode.getLabel())) == null) {
                PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
                ResourceBundle bundle = pcontext.getApplicationResourceBundle();
                resolvedLabel = ExpressionUtil.getExpressionValue((ResourceBundle)bundle, (String)pageNode.getLabel());
                resolvedLabel = EntityEncoder.FULL.encode(resolvedLabel);
                i18nizedLabels.put(pageNode.getLabel(), resolvedLabel);
            }
            return resolvedLabel;
        }
        return pageNode.getLabel();
    }

    public boolean hasChild(PageNode pageNode) {
        return pageNode != null && pageNode.getChildren() != null && !pageNode.getChildren().isEmpty();
    }

    public List<PageNode> getChildren(PageNode pageNode) {
        if (pageNode == null) {
            throw new IllegalArgumentException("getChildren method don't expect a null pageNode object.");
        }
        return pageNode.getChildren();
    }

    public List<PageNode> getPageNodes() throws Exception {
        if (this.setupMenuUserNodes == null) {
            this.setupMenuUserNodes = this.menuConfiguratorService.getSetupMenuItems(UISetupPlatformToolBarPortlet.getUserPortal());
        }
        if (this.setupMenuPageNodes == null) {
            this.setupMenuPageNodes = new ArrayList();
            List originalPageNodes = this.menuConfiguratorService.getSetupMenuOriginalPageNodes();
            if (this.setupMenuPageNodes != null) {
                for (PageNode pageNode : originalPageNodes) {
                    if (!this.hasPermissionOnPageNode(pageNode)) continue;
                    this.setupMenuPageNodes.add(pageNode);
                }
            }
        }
        return this.setupMenuPageNodes;
    }

    private UserNode getOriginalUserNode(String pageReference) {
        if (pageReference == null || pageReference.isEmpty()) {
            return null;
        }
        for (UserNode userNode : this.setupMenuUserNodes) {
            if (!userNode.getPageRef().format().equals(pageReference)) continue;
            return userNode;
        }
        return null;
    }
}

