/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory;

import java.time.Instant;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.gadget.services.LoginHistory.storage.JCRLoginHistoryStorageImpl;
import org.exoplatform.platform.gadget.services.LoginHistory.storage.LoginHistoryStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LoginHistoryUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(LoginHistoryUpgradePlugin.class);
    private static final int LOGIN_HISTORY_NODE_PAGE_SIZE = 50;
    private JCRLoginHistoryStorageImpl jcrLoginHistoryStorage;
    private LoginHistoryStorage jpaLoginHistoryStorage;
    private RepositoryService repositoryService;
    private EntityManagerService entityManagerService;

    public LoginHistoryUpgradePlugin(InitParams initParams, JCRLoginHistoryStorageImpl jcrLoginHistoryStorage, LoginHistoryStorage jpaLoginHistoryStorage, RepositoryService repositoryService, EntityManagerService entityManagerService) {
        super(initParams);
        this.jcrLoginHistoryStorage = jcrLoginHistoryStorage;
        this.jpaLoginHistoryStorage = jpaLoginHistoryStorage;
        this.repositoryService = repositoryService;
        this.entityManagerService = entityManagerService;
    }

    public void processUpgrade(String newVersion, String previousVersion) {
        if (!this.hasDataToMigrate().booleanValue()) {
            LOG.info((Object)"== No Login History data to migrate from JCR to RDBMS");
        } else {
            LOG.info((Object)"== Start migration of Login History data from JCR to RDBMS");
            int migrationErrors = this.migrateLoginHistory();
            if (migrationErrors == 0) {
                int allUsersCountersDeletionErrors = this.deleteAllUsersLoginHistoryCounters();
                if (allUsersCountersDeletionErrors == 0) {
                    LOG.info((Object)"==    Login History migration - Login History All Users Counters JCR Data deleted successfully");
                } else {
                    LOG.warn("==    Login History migration - {} Errors during Login History All Users Counters JCR Data deletion", new Object[]{allUsersCountersDeletionErrors});
                }
                int countersDeletionErrors = this.deleteLoginHistoryCounters();
                if (countersDeletionErrors == 0) {
                    LOG.info((Object)"==    Login History migration - Login History Counters JCR Data deleted successfully");
                } else {
                    LOG.warn("==    Login History migration - {} Errors during Login History Counters JCR Data deletion", new Object[]{countersDeletionErrors});
                }
                int deleteAllLoginHistoryNodesErrors = this.deleteAllLoginHistoryNodes();
                if (deleteAllLoginHistoryNodesErrors == 0) {
                    LOG.info((Object)"==    Login History migration - All Login History Entries JCR Data deleted successfully");
                } else {
                    LOG.warn("==    Login History migration - {} Errors during All Login History Entries JCR Data deletion", new Object[]{deleteAllLoginHistoryNodesErrors});
                }
                int usersProfilesDeletionErrors = this.deleteLoginHistoryProfiles();
                if (usersProfilesDeletionErrors == 0) {
                    LOG.info((Object)"==    Login History migration - Login History Users Profiles deleted successfully");
                } else {
                    LOG.warn("==    Login History migration - {} Errors during Login History Users Profiles JCR Data deletion", new Object[]{usersProfilesDeletionErrors});
                }
                if (countersDeletionErrors > 0 || usersProfilesDeletionErrors > 0 || allUsersCountersDeletionErrors > 0 || deleteAllLoginHistoryNodesErrors > 0) {
                    throw new RuntimeException("== Login History migration aborted due to errors during the deletion of Login History Counters and Users Profiles");
                }
                try {
                    this.jcrLoginHistoryStorage.removeLoginHistoryHomeNode();
                }
                catch (Exception e) {
                    throw new RuntimeException("== Login History migration - Error when deleting Login History home node");
                }
                LOG.info((Object)"==    Login History migration - Home Node deleted successfully !");
                LOG.info((Object)"== Login History migration done");
            } else {
                LOG.error("==    Login History migration aborted, {} errors encountered", new Object[]{migrationErrors});
                throw new RuntimeException("== Login History migration aborted because of migration failures");
            }
        }
    }

    private Session getSession(SessionProvider sessionProvider) throws Exception {
        ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
        return sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean hasDataToMigrate() {
        boolean hasDataToMigrate;
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Session session = this.getSession(sProvider);
            hasDataToMigrate = session.getRootNode().hasNode("exo:LoginHistoryHome");
        }
        return hasDataToMigrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int migrateLoginHistory() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        this.entityManagerService.startRequest(ExoContainerContext.getCurrentContainer());
        long offset = 0L;
        long migrated = 0L;
        int errors = 0;
        try {
            long count;
            long countLoginHistoryNodes = this.jcrLoginHistoryStorage.countLoginHistoryNodes(sProvider);
            long countAllUsersLoginHistoryCountersNodes = this.jcrLoginHistoryStorage.countGlobalLoginHistoryCountersNodes(sProvider);
            long countLoginHistoryCountersNodes = this.jcrLoginHistoryStorage.countLoginHistoryCountersNodes(sProvider) - countAllUsersLoginHistoryCountersNodes;
            long countUsersProfilesNodes = this.jcrLoginHistoryStorage.getAllUsersProfilesNodes(sProvider).getSize();
            LOG.info("==    Login History migration - ({}) Total Login History Nodes to migrate !", new Object[]{countLoginHistoryNodes});
            LOG.info("==    Login History migration - ({}) Total All Users Login History Counters Nodes to delete !", new Object[]{countAllUsersLoginHistoryCountersNodes});
            LOG.info("==    Login History migration - ({}) Total Login History Counters Nodes to delete !", new Object[]{countLoginHistoryCountersNodes});
            LOG.info("==    Login History migration - ({}) Total Login History Users Profiles to delete !", new Object[]{countUsersProfilesNodes});
            do {
                this.entityManagerService.endRequest(ExoContainerContext.getCurrentContainer());
                this.entityManagerService.startRequest(ExoContainerContext.getCurrentContainer());
                NodeIterator loginHistoryNodes = this.jcrLoginHistoryStorage.getLoginHistoryNodes(sProvider, offset, 50L);
                count = loginHistoryNodes.getSize();
                String userId = null;
                Instant instantLoginTime = null;
                while (loginHistoryNodes.hasNext()) {
                    try {
                        Node loginHistoryNode = loginHistoryNodes.nextNode();
                        userId = loginHistoryNode.getProperty("exo:LoginHisSvc_loginHistoryItem_userId").getString();
                        long loginTime = loginHistoryNode.getProperty("exo:LoginHisSvc_loginHistoryItem_loginTime").getLong();
                        instantLoginTime = Instant.ofEpochMilli(loginTime);
                        String path = loginHistoryNode.getPath();
                        LOG.debug("==    Login History migration - Migrate Login History Entry of user {} at {}", new Object[]{userId, instantLoginTime});
                        this.jpaLoginHistoryStorage.addLoginHistoryEntry(userId, loginTime);
                        ++migrated;
                    }
                    catch (Exception e) {
                        LOG.error("==    Login History migration - Error while migrating Login History Entry of user {} at {} ", new Object[]{userId, instantLoginTime, e});
                        ++errors;
                    }
                }
                offset += count;
                LOG.info("==    Login History migration - Progress : {} Login History Entries migrated ({} errors)", new Object[]{migrated, errors});
            } while (count == 50L);
        }
        finally {
            this.entityManagerService.endRequest(ExoContainerContext.getCurrentContainer());
            sProvider.close();
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteAllUsersLoginHistoryCounters() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Session session = null;
        String path = null;
        long offset = 0L;
        long removed = 0L;
        int errors = 0;
        try {
            long count;
            do {
                try {
                    session = this.getSession(sProvider);
                }
                catch (Exception e) {
                    LOG.error("==    Login History migration - Error while getting JCR Session for delete All Users Login History Counters : ", new Object[]{e.getMessage(), e});
                }
                NodeIterator loginCountersNodes = this.jcrLoginHistoryStorage.getAllUsersLoginCountersNodes(sProvider, offset, 50L);
                count = loginCountersNodes.getSize();
                while (loginCountersNodes.hasNext()) {
                    try {
                        Node loginCounterNode = loginCountersNodes.nextNode();
                        path = loginCounterNode.getPath();
                        loginCounterNode.remove();
                        if (++removed % 10L != 0L) continue;
                        session.save();
                    }
                    catch (Exception e) {
                        LOG.error("==    Login History migration - Error while deleting All Users Login Counter Node {} : " + path, new Object[]{e.getMessage(), e});
                        ++errors;
                    }
                }
                try {
                    session.save();
                }
                catch (Exception e) {
                    LOG.error("==    Login History migration - Error while saving JCR Session delete All Users Login History Counters : ", new Object[]{e.getMessage(), e});
                }
                offset += count;
                LOG.info("==    Login History migration - Progress : {} All Users Login Counters removed ({} errors)", new Object[]{removed, errors});
            } while (count == 50L);
            LOG.info((Object)"==    Login History migration - Removing All Users Profile Node");
            try {
                this.jcrLoginHistoryStorage.removeAllUsersProfileNode(sProvider);
            }
            catch (Exception e) {
                LOG.error((Object)"==    Login History migration - Error while removing All Users Profile Node : ", (Throwable)e);
                ++errors;
            }
        }
        finally {
            sProvider.close();
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteLoginHistoryCounters() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Session session = null;
        String userId = null;
        String day = null;
        long offset = 0L;
        long removed = 0L;
        int errors = 0;
        try {
            long count;
            do {
                try {
                    session = this.getSession(sProvider);
                }
                catch (Exception e) {
                    LOG.error("==    Login History migration - Error while getting JCR Session for delete Login History Counters : ", new Object[]{e.getMessage(), e});
                }
                NodeIterator usersProfilesNodes = this.jcrLoginHistoryStorage.getUsersProfilesNodes(sProvider, offset, 50L);
                count = usersProfilesNodes.getSize();
                while (usersProfilesNodes.hasNext()) {
                    Node userProfileNode = usersProfilesNodes.nextNode();
                    NodeIterator userLoginCountersNodes = this.jcrLoginHistoryStorage.getAllUserLoginCountersNodes(userProfileNode);
                    long countLoginCountersNodes = userLoginCountersNodes.getSize();
                    long userLoginCountersNodesRemoved = 0L;
                    try {
                        userId = userProfileNode.getProperty("exo:LoginHisSvc_userId").getString();
                    }
                    catch (Exception e) {
                        LOG.error("==    Login History migration - Error while retrieving the UserId for : ", new Object[]{userProfileNode});
                    }
                    LOG.debug("==    Login History migration - ({}) Login Counters Nodes to delete for user : {}", new Object[]{countLoginCountersNodes, userId});
                    while (userLoginCountersNodes.hasNext()) {
                        try {
                            Node userLoginCounterNode = userLoginCountersNodes.nextNode();
                            day = userLoginCounterNode.getProperty("exo:LoginHisSvc_loginCounterItem_loginDate").getString();
                            userLoginCounterNode.remove();
                            ++userLoginCountersNodesRemoved;
                            if (++removed % 10L != 0L) continue;
                            session.save();
                        }
                        catch (Exception e) {
                            LOG.error("==    Login History migration - Error while deleting Login Counter Node for {} of user {} : ", new Object[]{day, userId, e.getMessage(), e});
                            ++errors;
                        }
                    }
                    try {
                        session.save();
                    }
                    catch (Exception e) {
                        LOG.error("==    Login History migration - Error while saving JCR Session for delete Login History Counters : ", new Object[]{e.getMessage(), e});
                    }
                    if (userLoginCountersNodesRemoved == 0L) continue;
                    LOG.debug("==    Login History migration - ({}) Total Login Counters Nodes deleted for user : {}", new Object[]{userLoginCountersNodesRemoved, userId});
                }
                offset += count;
                LOG.info("==    Login History migration - Progress : {} Total Users Login Counters removed ({} errors)", new Object[]{removed, errors});
            } while (count == 50L);
        }
        finally {
            sProvider.close();
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteAllLoginHistoryNodes() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Session session = null;
        String userId = null;
        long offset = 0L;
        long removed = 0L;
        int errors = 0;
        try {
            long count;
            do {
                try {
                    session = this.getSession(sProvider);
                }
                catch (Exception e) {
                    LOG.error("==    Login History migration - Error while getting JCR Session for delete All Login History Nodes : ", new Object[]{e.getMessage(), e});
                }
                NodeIterator usersProfilesNodes = this.jcrLoginHistoryStorage.getUsersProfilesNodes(sProvider, offset, 50L);
                count = usersProfilesNodes.getSize();
                while (usersProfilesNodes.hasNext()) {
                    Node userProfileNode = usersProfilesNodes.nextNode();
                    NodeIterator userLoginHistoryNodes = this.jcrLoginHistoryStorage.getAllUserLoginHistoryNodes(userProfileNode);
                    long countLoginHistoryNodes = userLoginHistoryNodes.getSize();
                    long userLoginHistoryNodesRemoved = 0L;
                    try {
                        userId = userProfileNode.getProperty("exo:LoginHisSvc_userId").getString();
                    }
                    catch (Exception e) {
                        LOG.error("==    Login History migration - Error while retrieving the UserId for : ", new Object[]{userProfileNode});
                    }
                    LOG.debug("==    Login History migration - ({}) Login History Nodes to delete for user : {}", new Object[]{countLoginHistoryNodes, userId});
                    while (userLoginHistoryNodes.hasNext()) {
                        try {
                            Node userLoginHistoryNode = userLoginHistoryNodes.nextNode();
                            userLoginHistoryNode.remove();
                            ++userLoginHistoryNodesRemoved;
                            if (++removed % 10L != 0L) continue;
                            session.save();
                        }
                        catch (Exception e) {
                            LOG.error("==    Login History migration - Error while deleting All Login History Nodes for user {} : ", new Object[]{userId, e.getMessage(), e});
                            ++errors;
                        }
                    }
                    if (userLoginHistoryNodesRemoved == 0L) continue;
                    LOG.debug("==    Login History migration - ({}) Total Login History Nodes deleted for user : {}", new Object[]{userLoginHistoryNodesRemoved, userId});
                }
                try {
                    session.save();
                }
                catch (Exception e) {
                    LOG.error("==    Login History migration - Error while saving JCR Session for delete All Login History Nodes : ", new Object[]{e.getMessage(), e});
                }
                offset += count;
                LOG.info("==    Login History migration - Progress : {} All Login History Nodes removed ({} errors)", new Object[]{removed, errors});
            } while (count == 50L);
        }
        finally {
            sProvider.close();
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteLoginHistoryProfiles() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Session session = null;
        String userId = null;
        long removed = 0L;
        int errors = 0;
        try {
            try {
                session = this.getSession(sProvider);
            }
            catch (Exception e) {
                LOG.error("==    Login History migration - Error while getting JCR Session for delete Login History Profiles : ", new Object[]{e.getMessage(), e});
            }
            NodeIterator loginHistoryProfilesNodes = this.jcrLoginHistoryStorage.getAllUsersProfilesNodes(sProvider);
            while (loginHistoryProfilesNodes.hasNext()) {
                try {
                    Node loginHistoryProfileNode = loginHistoryProfilesNodes.nextNode();
                    userId = loginHistoryProfileNode.getProperty("exo:LoginHisSvc_userId").getString();
                    this.jcrLoginHistoryStorage.removeLoginHistoryUserProfileChildNodes(session, userId);
                    LOG.debug("==    Login History migration - User Profile child Nodes for User {} removed successfully !", new Object[]{userId});
                    loginHistoryProfileNode.remove();
                    LOG.debug("==    Login History migration - User Profile for user {} removed successfully !", new Object[]{userId});
                    if (++removed % 10L != 0L) continue;
                    session.save();
                }
                catch (Exception e) {
                    LOG.error("==    Login History migration - Error while removing Login History User Profile for user {} : ", new Object[]{userId, e});
                    ++errors;
                }
            }
            try {
                session.save();
            }
            catch (Exception e) {
                LOG.error("==    Login History migration - Error while saving JCR Session for delete Login History Profiles : ", new Object[]{e.getMessage(), e});
            }
            LOG.info("==    Login History migration - Progress : {} Login History Profiles removed ({} errors)", new Object[]{removed, errors});
        }
        finally {
            sProvider.close();
        }
        return errors;
    }
}

