/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mailintegration.dao;

import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.mailintegration.dao.MailIntegrationDAO;
import org.exoplatform.mailintegration.entity.MailIntegrationSettingEntity;
import org.exoplatform.services.naming.InitialContextInitializer;

public class MailIntegrationDaoTest
extends TestCase {
    private PortalContainer container;
    private String emailName = "user1@exo.tn";
    private String imapUrl = "imap.gmail.com";
    private long port = 123L;
    private String encryption = "SSL";
    private String account = "user1@exo.tn";
    private String password = "123456";
    private long userId = 1L;
    private MailIntegrationDAO mailIntegrationDAO;

    protected void setUp() throws Exception {
        RootContainer rootContainer = RootContainer.getInstance();
        rootContainer.getComponentInstanceOfType(InitialContextInitializer.class);
        this.container = PortalContainer.getInstance();
        this.mailIntegrationDAO = (MailIntegrationDAO)this.container.getComponentInstanceOfType(MailIntegrationDAO.class);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        this.begin();
    }

    public void testCreateMailIntegrationSetting() {
        MailIntegrationSettingEntity createdMailIntegrationSettingEntity = this.createMailIntegrationSettingEntity();
        createdMailIntegrationSettingEntity = (MailIntegrationSettingEntity)this.mailIntegrationDAO.create((Object)createdMailIntegrationSettingEntity);
        MailIntegrationDaoTest.assertNotNull((Object)createdMailIntegrationSettingEntity);
        MailIntegrationDaoTest.assertNotNull((Object)createdMailIntegrationSettingEntity.getId());
        MailIntegrationDaoTest.assertEquals((String)this.emailName, (String)createdMailIntegrationSettingEntity.getEmailName());
        MailIntegrationDaoTest.assertEquals((String)this.imapUrl, (String)createdMailIntegrationSettingEntity.getImapUrl());
        MailIntegrationDaoTest.assertEquals((long)this.port, (long)createdMailIntegrationSettingEntity.getPort());
        MailIntegrationDaoTest.assertEquals((String)this.encryption, (String)createdMailIntegrationSettingEntity.getEncryption());
        MailIntegrationDaoTest.assertEquals((String)this.account, (String)createdMailIntegrationSettingEntity.getAccount());
        MailIntegrationDaoTest.assertEquals((String)this.password, (String)createdMailIntegrationSettingEntity.getPassword());
        MailIntegrationDaoTest.assertEquals((long)this.userId, (long)createdMailIntegrationSettingEntity.getUserId());
    }

    public void testGetMailIntegrationSettingsByUserId() {
        MailIntegrationSettingEntity createdMailIntegrationSetting = this.createMailIntegrationSettingEntity();
        createdMailIntegrationSetting = (MailIntegrationSettingEntity)this.mailIntegrationDAO.create((Object)createdMailIntegrationSetting);
        List retrievedMailIntegrationSettingEntities = this.mailIntegrationDAO.findMailIntegrationSettingsByUserId(createdMailIntegrationSetting.getUserId());
        MailIntegrationSettingEntity retrievedMailIntegrationSetting = (MailIntegrationSettingEntity)retrievedMailIntegrationSettingEntities.get(0);
        MailIntegrationDaoTest.assertNotNull((Object)retrievedMailIntegrationSetting);
        MailIntegrationDaoTest.assertEquals((String)this.emailName, (String)retrievedMailIntegrationSetting.getEmailName());
        MailIntegrationDaoTest.assertEquals((String)this.imapUrl, (String)retrievedMailIntegrationSetting.getImapUrl());
        MailIntegrationDaoTest.assertEquals((long)this.port, (long)retrievedMailIntegrationSetting.getPort());
        MailIntegrationDaoTest.assertEquals((String)this.encryption, (String)retrievedMailIntegrationSetting.getEncryption());
        MailIntegrationDaoTest.assertEquals((String)this.account, (String)retrievedMailIntegrationSetting.getAccount());
        MailIntegrationDaoTest.assertEquals((long)this.userId, (long)retrievedMailIntegrationSetting.getUserId());
    }

    public void testUpdateMailIntegrationSetting() {
        MailIntegrationSettingEntity createdMailIntegrationSettingEntity = this.createMailIntegrationSettingEntity();
        createdMailIntegrationSettingEntity = (MailIntegrationSettingEntity)this.mailIntegrationDAO.create((Object)createdMailIntegrationSettingEntity);
        createdMailIntegrationSettingEntity.setAccount("updatedAccount");
        MailIntegrationSettingEntity updatedMailIntegrationSetting = (MailIntegrationSettingEntity)this.mailIntegrationDAO.update((Object)createdMailIntegrationSettingEntity);
        MailIntegrationDaoTest.assertNotNull((Object)updatedMailIntegrationSetting);
        MailIntegrationDaoTest.assertNotNull((Object)updatedMailIntegrationSetting.getId());
        MailIntegrationDaoTest.assertEquals((String)this.emailName, (String)updatedMailIntegrationSetting.getEmailName());
        MailIntegrationDaoTest.assertEquals((String)this.imapUrl, (String)updatedMailIntegrationSetting.getImapUrl());
        MailIntegrationDaoTest.assertEquals((long)this.port, (long)updatedMailIntegrationSetting.getPort());
        MailIntegrationDaoTest.assertEquals((String)this.encryption, (String)updatedMailIntegrationSetting.getEncryption());
        MailIntegrationDaoTest.assertEquals((String)"updatedAccount", (String)updatedMailIntegrationSetting.getAccount());
        MailIntegrationDaoTest.assertEquals((long)this.userId, (long)updatedMailIntegrationSetting.getUserId());
    }

    protected MailIntegrationSettingEntity createMailIntegrationSettingEntity() {
        MailIntegrationSettingEntity mailIntegrationSettingEntity = new MailIntegrationSettingEntity();
        mailIntegrationSettingEntity.setEmailName(this.emailName);
        mailIntegrationSettingEntity.setImapUrl(this.imapUrl);
        mailIntegrationSettingEntity.setPort(this.port);
        mailIntegrationSettingEntity.setEncryption(this.encryption);
        mailIntegrationSettingEntity.setAccount(this.account);
        mailIntegrationSettingEntity.setPassword(this.password);
        mailIntegrationSettingEntity.setUserId(this.userId);
        return mailIntegrationSettingEntity;
    }

    protected void tearDown() throws Exception {
        this.end();
    }

    private void begin() {
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    private void end() {
        RequestLifeCycle.end();
    }
}

